/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.config.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.openshift.api.model.v6_7.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_7.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_7.config.v1.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_7.config.v1.ProxySpec;
import io.fabric8.openshift.api.model.v6_7.config.v1.ProxySpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProxySpecFluentImpl<A extends ProxySpecFluent<A>>
extends BaseFluent<A>
implements ProxySpecFluent<A> {
    private String httpProxy;
    private String httpsProxy;
    private String noProxy;
    private List<String> readinessEndpoints = new ArrayList<String>();
    private ConfigMapNameReferenceBuilder trustedCA;
    private Map<String, Object> additionalProperties;

    public ProxySpecFluentImpl() {
    }

    public ProxySpecFluentImpl(ProxySpec instance) {
        if (instance != null) {
            this.withHttpProxy(instance.getHttpProxy());
            this.withHttpsProxy(instance.getHttpsProxy());
            this.withNoProxy(instance.getNoProxy());
            this.withReadinessEndpoints(instance.getReadinessEndpoints());
            this.withTrustedCA(instance.getTrustedCA());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getHttpProxy() {
        return this.httpProxy;
    }

    @Override
    public A withHttpProxy(String httpProxy) {
        this.httpProxy = httpProxy;
        return (A)this;
    }

    @Override
    public Boolean hasHttpProxy() {
        return this.httpProxy != null;
    }

    @Override
    public String getHttpsProxy() {
        return this.httpsProxy;
    }

    @Override
    public A withHttpsProxy(String httpsProxy) {
        this.httpsProxy = httpsProxy;
        return (A)this;
    }

    @Override
    public Boolean hasHttpsProxy() {
        return this.httpsProxy != null;
    }

    @Override
    public String getNoProxy() {
        return this.noProxy;
    }

    @Override
    public A withNoProxy(String noProxy) {
        this.noProxy = noProxy;
        return (A)this;
    }

    @Override
    public Boolean hasNoProxy() {
        return this.noProxy != null;
    }

    @Override
    public A addToReadinessEndpoints(int index, String item) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        this.readinessEndpoints.add(index, item);
        return (A)this;
    }

    @Override
    public A setToReadinessEndpoints(int index, String item) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        this.readinessEndpoints.set(index, item);
        return (A)this;
    }

    @Override
    public A addToReadinessEndpoints(String ... items) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.readinessEndpoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToReadinessEndpoints(Collection<String> items) {
        if (this.readinessEndpoints == null) {
            this.readinessEndpoints = new ArrayList<String>();
        }
        for (String item : items) {
            this.readinessEndpoints.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromReadinessEndpoints(String ... items) {
        for (String item : items) {
            if (this.readinessEndpoints == null) continue;
            this.readinessEndpoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReadinessEndpoints(Collection<String> items) {
        for (String item : items) {
            if (this.readinessEndpoints == null) continue;
            this.readinessEndpoints.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getReadinessEndpoints() {
        return this.readinessEndpoints;
    }

    @Override
    public String getReadinessEndpoint(int index) {
        return this.readinessEndpoints.get(index);
    }

    @Override
    public String getFirstReadinessEndpoint() {
        return this.readinessEndpoints.get(0);
    }

    @Override
    public String getLastReadinessEndpoint() {
        return this.readinessEndpoints.get(this.readinessEndpoints.size() - 1);
    }

    @Override
    public String getMatchingReadinessEndpoint(Predicate<String> predicate) {
        for (String item : this.readinessEndpoints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReadinessEndpoint(Predicate<String> predicate) {
        for (String item : this.readinessEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReadinessEndpoints(List<String> readinessEndpoints) {
        if (readinessEndpoints != null) {
            this.readinessEndpoints = new ArrayList<String>();
            for (String item : readinessEndpoints) {
                this.addToReadinessEndpoints(item);
            }
        } else {
            this.readinessEndpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withReadinessEndpoints(String ... readinessEndpoints) {
        if (this.readinessEndpoints != null) {
            this.readinessEndpoints.clear();
            this._visitables.remove("readinessEndpoints");
        }
        if (readinessEndpoints != null) {
            for (String item : readinessEndpoints) {
                this.addToReadinessEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReadinessEndpoints() {
        return this.readinessEndpoints != null && !this.readinessEndpoints.isEmpty();
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getTrustedCA() {
        return this.trustedCA != null ? this.trustedCA.build() : null;
    }

    @Override
    public ConfigMapNameReference buildTrustedCA() {
        return this.trustedCA != null ? this.trustedCA.build() : null;
    }

    @Override
    public A withTrustedCA(ConfigMapNameReference trustedCA) {
        this._visitables.get("trustedCA").remove(this.trustedCA);
        if (trustedCA != null) {
            this.trustedCA = new ConfigMapNameReferenceBuilder(trustedCA);
            this._visitables.get("trustedCA").add(this.trustedCA);
        } else {
            this.trustedCA = null;
            this._visitables.get("trustedCA").remove(this.trustedCA);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTrustedCA() {
        return this.trustedCA != null;
    }

    @Override
    public A withNewTrustedCA(String name) {
        return this.withTrustedCA(new ConfigMapNameReference(name));
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> withNewTrustedCA() {
        return new TrustedCANestedImpl();
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> withNewTrustedCALike(ConfigMapNameReference item) {
        return new TrustedCANestedImpl(item);
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> editTrustedCA() {
        return this.withNewTrustedCALike(this.getTrustedCA());
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCA() {
        return this.withNewTrustedCALike(this.getTrustedCA() != null ? this.getTrustedCA() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public ProxySpecFluent.TrustedCANested<A> editOrNewTrustedCALike(ConfigMapNameReference item) {
        return this.withNewTrustedCALike(this.getTrustedCA() != null ? this.getTrustedCA() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProxySpecFluentImpl that = (ProxySpecFluentImpl)o;
        if (!Objects.equals(this.httpProxy, that.httpProxy)) {
            return false;
        }
        if (!Objects.equals(this.httpsProxy, that.httpsProxy)) {
            return false;
        }
        if (!Objects.equals(this.noProxy, that.noProxy)) {
            return false;
        }
        if (!Objects.equals(this.readinessEndpoints, that.readinessEndpoints)) {
            return false;
        }
        if (!Objects.equals(this.trustedCA, that.trustedCA)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.httpProxy, this.httpsProxy, this.noProxy, this.readinessEndpoints, this.trustedCA, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.httpProxy != null) {
            sb.append("httpProxy:");
            sb.append(this.httpProxy + ",");
        }
        if (this.httpsProxy != null) {
            sb.append("httpsProxy:");
            sb.append(this.httpsProxy + ",");
        }
        if (this.noProxy != null) {
            sb.append("noProxy:");
            sb.append(this.noProxy + ",");
        }
        if (this.readinessEndpoints != null && !this.readinessEndpoints.isEmpty()) {
            sb.append("readinessEndpoints:");
            sb.append(this.readinessEndpoints + ",");
        }
        if (this.trustedCA != null) {
            sb.append("trustedCA:");
            sb.append(this.trustedCA + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TrustedCANestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<ProxySpecFluent.TrustedCANested<N>>
    implements ProxySpecFluent.TrustedCANested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        TrustedCANestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        TrustedCANestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ProxySpecFluentImpl.this.withTrustedCA(this.builder.build());
        }

        @Override
        public N endTrustedCA() {
            return this.and();
        }
    }
}

