/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.config.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.Toleration;
import io.fabric8.openshift.api.model.v6_7.config.v1.BuildOverrides;
import io.fabric8.openshift.api.model.v6_7.config.v1.BuildOverridesFluent;
import io.fabric8.openshift.api.model.v6_7.config.v1.ImageLabel;
import io.fabric8.openshift.api.model.v6_7.config.v1.ImageLabelBuilder;
import io.fabric8.openshift.api.model.v6_7.config.v1.ImageLabelFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildOverridesFluentImpl<A extends BuildOverridesFluent<A>>
extends BaseFluent<A>
implements BuildOverridesFluent<A> {
    private Boolean forcePull;
    private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList();
    private Map<String, String> nodeSelector;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public BuildOverridesFluentImpl() {
    }

    public BuildOverridesFluentImpl(BuildOverrides instance) {
        if (instance != null) {
            this.withForcePull(instance.getForcePull());
            this.withImageLabels(instance.getImageLabels());
            this.withNodeSelector(instance.getNodeSelector());
            this.withTolerations(instance.getTolerations());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Boolean getForcePull() {
        return this.forcePull;
    }

    @Override
    public A withForcePull(Boolean forcePull) {
        this.forcePull = forcePull;
        return (A)this;
    }

    @Override
    public Boolean hasForcePull() {
        return this.forcePull != null;
    }

    @Override
    public A addToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").add(index, builder);
            this.imageLabels.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").set(index, builder);
            this.imageLabels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImageLabels(ImageLabel ... items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImageLabels(Collection<ImageLabel> items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImageLabels(ImageLabel ... items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            if (this.imageLabels == null) continue;
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImageLabels(Collection<ImageLabel> items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            if (this.imageLabels == null) continue;
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
        if (this.imageLabels == null) {
            return (A)this;
        }
        Iterator<ImageLabelBuilder> each = this.imageLabels.iterator();
        Object visitables = this._visitables.get("imageLabels");
        while (each.hasNext()) {
            ImageLabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageLabel> getImageLabels() {
        return this.imageLabels != null ? BuildOverridesFluentImpl.build(this.imageLabels) : null;
    }

    @Override
    public List<ImageLabel> buildImageLabels() {
        return this.imageLabels != null ? BuildOverridesFluentImpl.build(this.imageLabels) : null;
    }

    @Override
    public ImageLabel buildImageLabel(int index) {
        return this.imageLabels.get(index).build();
    }

    @Override
    public ImageLabel buildFirstImageLabel() {
        return this.imageLabels.get(0).build();
    }

    @Override
    public ImageLabel buildLastImageLabel() {
        return this.imageLabels.get(this.imageLabels.size() - 1).build();
    }

    @Override
    public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImageLabels(List<ImageLabel> imageLabels) {
        if (this.imageLabels != null) {
            this._visitables.get("imageLabels").clear();
        }
        if (imageLabels != null) {
            this.imageLabels = new ArrayList();
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        } else {
            this.imageLabels = null;
        }
        return (A)this;
    }

    @Override
    public A withImageLabels(ImageLabel ... imageLabels) {
        if (this.imageLabels != null) {
            this.imageLabels.clear();
            this._visitables.remove("imageLabels");
        }
        if (imageLabels != null) {
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageLabels() {
        return this.imageLabels != null && !this.imageLabels.isEmpty();
    }

    @Override
    public A addNewImageLabel(String name, String value) {
        return this.addToImageLabels(new ImageLabel(name, value));
    }

    @Override
    public BuildOverridesFluent.ImageLabelsNested<A> addNewImageLabel() {
        return new ImageLabelsNestedImpl();
    }

    @Override
    public BuildOverridesFluent.ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
        return new ImageLabelsNestedImpl(-1, item);
    }

    @Override
    public BuildOverridesFluent.ImageLabelsNested<A> setNewImageLabelLike(int index, ImageLabel item) {
        return new ImageLabelsNestedImpl(index, item);
    }

    @Override
    public BuildOverridesFluent.ImageLabelsNested<A> editImageLabel(int index) {
        if (this.imageLabels.size() <= index) {
            throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildOverridesFluent.ImageLabelsNested<A> editFirstImageLabel() {
        if (this.imageLabels.size() == 0) {
            throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(0, this.buildImageLabel(0));
    }

    @Override
    public BuildOverridesFluent.ImageLabelsNested<A> editLastImageLabel() {
        int index = this.imageLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildOverridesFluent.ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageLabels.size(); ++i) {
            if (!predicate.test(this.imageLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageLabels. No match found.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    public A addToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(int index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
            this._visitables.remove("tolerations");
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildOverridesFluentImpl that = (BuildOverridesFluentImpl)o;
        if (!Objects.equals(this.forcePull, that.forcePull)) {
            return false;
        }
        if (!Objects.equals(this.imageLabels, that.imageLabels)) {
            return false;
        }
        if (!Objects.equals(this.nodeSelector, that.nodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.tolerations, that.tolerations)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.forcePull, this.imageLabels, this.nodeSelector, this.tolerations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.forcePull != null) {
            sb.append("forcePull:");
            sb.append(this.forcePull + ",");
        }
        if (this.imageLabels != null) {
            sb.append("imageLabels:");
            sb.append(this.imageLabels + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withForcePull() {
        return this.withForcePull(true);
    }

    class ImageLabelsNestedImpl<N>
    extends ImageLabelFluentImpl<BuildOverridesFluent.ImageLabelsNested<N>>
    implements BuildOverridesFluent.ImageLabelsNested<N>,
    Nested<N> {
        ImageLabelBuilder builder;
        int index;

        ImageLabelsNestedImpl(int index, ImageLabel item) {
            this.index = index;
            this.builder = new ImageLabelBuilder(this, item);
        }

        ImageLabelsNestedImpl() {
            this.index = -1;
            this.builder = new ImageLabelBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOverridesFluentImpl.this.setToImageLabels(this.index, this.builder.build());
        }

        @Override
        public N endImageLabel() {
            return this.and();
        }
    }
}

