/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.config.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.EnvVar;
import io.fabric8.kubernetes.api.model.v6_7.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_7.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ResourceRequirementsFluentImpl;
import io.fabric8.openshift.api.model.v6_7.config.v1.BuildDefaults;
import io.fabric8.openshift.api.model.v6_7.config.v1.BuildDefaultsFluent;
import io.fabric8.openshift.api.model.v6_7.config.v1.ImageLabel;
import io.fabric8.openshift.api.model.v6_7.config.v1.ImageLabelBuilder;
import io.fabric8.openshift.api.model.v6_7.config.v1.ImageLabelFluentImpl;
import io.fabric8.openshift.api.model.v6_7.config.v1.ProxySpec;
import io.fabric8.openshift.api.model.v6_7.config.v1.ProxySpecBuilder;
import io.fabric8.openshift.api.model.v6_7.config.v1.ProxySpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildDefaultsFluentImpl<A extends BuildDefaultsFluent<A>>
extends BaseFluent<A>
implements BuildDefaultsFluent<A> {
    private ProxySpecBuilder defaultProxy;
    private List<EnvVar> env = new ArrayList<EnvVar>();
    private ProxySpecBuilder gitProxy;
    private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList();
    private ResourceRequirementsBuilder resources;
    private Map<String, Object> additionalProperties;

    public BuildDefaultsFluentImpl() {
    }

    public BuildDefaultsFluentImpl(BuildDefaults instance) {
        if (instance != null) {
            this.withDefaultProxy(instance.getDefaultProxy());
            this.withEnv(instance.getEnv());
            this.withGitProxy(instance.getGitProxy());
            this.withImageLabels(instance.getImageLabels());
            this.withResources(instance.getResources());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public ProxySpec getDefaultProxy() {
        return this.defaultProxy != null ? this.defaultProxy.build() : null;
    }

    @Override
    public ProxySpec buildDefaultProxy() {
        return this.defaultProxy != null ? this.defaultProxy.build() : null;
    }

    @Override
    public A withDefaultProxy(ProxySpec defaultProxy) {
        this._visitables.get("defaultProxy").remove(this.defaultProxy);
        if (defaultProxy != null) {
            this.defaultProxy = new ProxySpecBuilder(defaultProxy);
            this._visitables.get("defaultProxy").add(this.defaultProxy);
        } else {
            this.defaultProxy = null;
            this._visitables.get("defaultProxy").remove(this.defaultProxy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasDefaultProxy() {
        return this.defaultProxy != null;
    }

    @Override
    public BuildDefaultsFluent.DefaultProxyNested<A> withNewDefaultProxy() {
        return new DefaultProxyNestedImpl();
    }

    @Override
    public BuildDefaultsFluent.DefaultProxyNested<A> withNewDefaultProxyLike(ProxySpec item) {
        return new DefaultProxyNestedImpl(item);
    }

    @Override
    public BuildDefaultsFluent.DefaultProxyNested<A> editDefaultProxy() {
        return this.withNewDefaultProxyLike(this.getDefaultProxy());
    }

    @Override
    public BuildDefaultsFluent.DefaultProxyNested<A> editOrNewDefaultProxy() {
        return this.withNewDefaultProxyLike(this.getDefaultProxy() != null ? this.getDefaultProxy() : new ProxySpecBuilder().build());
    }

    @Override
    public BuildDefaultsFluent.DefaultProxyNested<A> editOrNewDefaultProxyLike(ProxySpec item) {
        return this.withNewDefaultProxyLike(this.getDefaultProxy() != null ? this.getDefaultProxy() : item);
    }

    @Override
    public A addToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.add(index, item);
        return (A)this;
    }

    @Override
    public A setToEnv(int index, EnvVar item) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        this.env.set(index, item);
        return (A)this;
    }

    @Override
    public A addToEnv(EnvVar ... items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToEnv(Collection<EnvVar> items) {
        if (this.env == null) {
            this.env = new ArrayList<EnvVar>();
        }
        for (EnvVar item : items) {
            this.env.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromEnv(EnvVar ... items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEnv(Collection<EnvVar> items) {
        for (EnvVar item : items) {
            if (this.env == null) continue;
            this.env.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<EnvVar> getEnv() {
        return this.env;
    }

    @Override
    public EnvVar getEnv(int index) {
        return this.env.get(index);
    }

    @Override
    public EnvVar getFirstEnv() {
        return this.env.get(0);
    }

    @Override
    public EnvVar getLastEnv() {
        return this.env.get(this.env.size() - 1);
    }

    @Override
    public EnvVar getMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEnv(Predicate<EnvVar> predicate) {
        for (EnvVar item : this.env) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEnv(List<EnvVar> env) {
        if (env != null) {
            this.env = new ArrayList<EnvVar>();
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        } else {
            this.env = null;
        }
        return (A)this;
    }

    @Override
    public A withEnv(EnvVar ... env) {
        if (this.env != null) {
            this.env.clear();
            this._visitables.remove("env");
        }
        if (env != null) {
            for (EnvVar item : env) {
                this.addToEnv(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEnv() {
        return this.env != null && !this.env.isEmpty();
    }

    @Override
    @Deprecated
    public ProxySpec getGitProxy() {
        return this.gitProxy != null ? this.gitProxy.build() : null;
    }

    @Override
    public ProxySpec buildGitProxy() {
        return this.gitProxy != null ? this.gitProxy.build() : null;
    }

    @Override
    public A withGitProxy(ProxySpec gitProxy) {
        this._visitables.get("gitProxy").remove(this.gitProxy);
        if (gitProxy != null) {
            this.gitProxy = new ProxySpecBuilder(gitProxy);
            this._visitables.get("gitProxy").add(this.gitProxy);
        } else {
            this.gitProxy = null;
            this._visitables.get("gitProxy").remove(this.gitProxy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasGitProxy() {
        return this.gitProxy != null;
    }

    @Override
    public BuildDefaultsFluent.GitProxyNested<A> withNewGitProxy() {
        return new GitProxyNestedImpl();
    }

    @Override
    public BuildDefaultsFluent.GitProxyNested<A> withNewGitProxyLike(ProxySpec item) {
        return new GitProxyNestedImpl(item);
    }

    @Override
    public BuildDefaultsFluent.GitProxyNested<A> editGitProxy() {
        return this.withNewGitProxyLike(this.getGitProxy());
    }

    @Override
    public BuildDefaultsFluent.GitProxyNested<A> editOrNewGitProxy() {
        return this.withNewGitProxyLike(this.getGitProxy() != null ? this.getGitProxy() : new ProxySpecBuilder().build());
    }

    @Override
    public BuildDefaultsFluent.GitProxyNested<A> editOrNewGitProxyLike(ProxySpec item) {
        return this.withNewGitProxyLike(this.getGitProxy() != null ? this.getGitProxy() : item);
    }

    @Override
    public A addToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").add(index, builder);
            this.imageLabels.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").set(index, builder);
            this.imageLabels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImageLabels(ImageLabel ... items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImageLabels(Collection<ImageLabel> items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImageLabels(ImageLabel ... items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            if (this.imageLabels == null) continue;
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImageLabels(Collection<ImageLabel> items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            if (this.imageLabels == null) continue;
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
        if (this.imageLabels == null) {
            return (A)this;
        }
        Iterator<ImageLabelBuilder> each = this.imageLabels.iterator();
        Object visitables = this._visitables.get("imageLabels");
        while (each.hasNext()) {
            ImageLabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageLabel> getImageLabels() {
        return this.imageLabels != null ? BuildDefaultsFluentImpl.build(this.imageLabels) : null;
    }

    @Override
    public List<ImageLabel> buildImageLabels() {
        return this.imageLabels != null ? BuildDefaultsFluentImpl.build(this.imageLabels) : null;
    }

    @Override
    public ImageLabel buildImageLabel(int index) {
        return this.imageLabels.get(index).build();
    }

    @Override
    public ImageLabel buildFirstImageLabel() {
        return this.imageLabels.get(0).build();
    }

    @Override
    public ImageLabel buildLastImageLabel() {
        return this.imageLabels.get(this.imageLabels.size() - 1).build();
    }

    @Override
    public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImageLabels(List<ImageLabel> imageLabels) {
        if (this.imageLabels != null) {
            this._visitables.get("imageLabels").clear();
        }
        if (imageLabels != null) {
            this.imageLabels = new ArrayList();
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        } else {
            this.imageLabels = null;
        }
        return (A)this;
    }

    @Override
    public A withImageLabels(ImageLabel ... imageLabels) {
        if (this.imageLabels != null) {
            this.imageLabels.clear();
            this._visitables.remove("imageLabels");
        }
        if (imageLabels != null) {
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageLabels() {
        return this.imageLabels != null && !this.imageLabels.isEmpty();
    }

    @Override
    public A addNewImageLabel(String name, String value) {
        return this.addToImageLabels(new ImageLabel(name, value));
    }

    @Override
    public BuildDefaultsFluent.ImageLabelsNested<A> addNewImageLabel() {
        return new ImageLabelsNestedImpl();
    }

    @Override
    public BuildDefaultsFluent.ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
        return new ImageLabelsNestedImpl(-1, item);
    }

    @Override
    public BuildDefaultsFluent.ImageLabelsNested<A> setNewImageLabelLike(int index, ImageLabel item) {
        return new ImageLabelsNestedImpl(index, item);
    }

    @Override
    public BuildDefaultsFluent.ImageLabelsNested<A> editImageLabel(int index) {
        if (this.imageLabels.size() <= index) {
            throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildDefaultsFluent.ImageLabelsNested<A> editFirstImageLabel() {
        if (this.imageLabels.size() == 0) {
            throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(0, this.buildImageLabel(0));
    }

    @Override
    public BuildDefaultsFluent.ImageLabelsNested<A> editLastImageLabel() {
        int index = this.imageLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildDefaultsFluent.ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageLabels.size(); ++i) {
            if (!predicate.test(this.imageLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageLabels. No match found.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public BuildDefaultsFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public BuildDefaultsFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public BuildDefaultsFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public BuildDefaultsFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public BuildDefaultsFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildDefaultsFluentImpl that = (BuildDefaultsFluentImpl)o;
        if (!Objects.equals(this.defaultProxy, that.defaultProxy)) {
            return false;
        }
        if (!Objects.equals(this.env, that.env)) {
            return false;
        }
        if (!Objects.equals(this.gitProxy, that.gitProxy)) {
            return false;
        }
        if (!Objects.equals(this.imageLabels, that.imageLabels)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultProxy, this.env, this.gitProxy, this.imageLabels, this.resources, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultProxy != null) {
            sb.append("defaultProxy:");
            sb.append(this.defaultProxy + ",");
        }
        if (this.env != null && !this.env.isEmpty()) {
            sb.append("env:");
            sb.append(this.env + ",");
        }
        if (this.gitProxy != null) {
            sb.append("gitProxy:");
            sb.append(this.gitProxy + ",");
        }
        if (this.imageLabels != null) {
            sb.append("imageLabels:");
            sb.append(this.imageLabels + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<BuildDefaultsFluent.ResourcesNested<N>>
    implements BuildDefaultsFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }

    class ImageLabelsNestedImpl<N>
    extends ImageLabelFluentImpl<BuildDefaultsFluent.ImageLabelsNested<N>>
    implements BuildDefaultsFluent.ImageLabelsNested<N>,
    Nested<N> {
        ImageLabelBuilder builder;
        int index;

        ImageLabelsNestedImpl(int index, ImageLabel item) {
            this.index = index;
            this.builder = new ImageLabelBuilder(this, item);
        }

        ImageLabelsNestedImpl() {
            this.index = -1;
            this.builder = new ImageLabelBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluentImpl.this.setToImageLabels(this.index, this.builder.build());
        }

        @Override
        public N endImageLabel() {
            return this.and();
        }
    }

    class GitProxyNestedImpl<N>
    extends ProxySpecFluentImpl<BuildDefaultsFluent.GitProxyNested<N>>
    implements BuildDefaultsFluent.GitProxyNested<N>,
    Nested<N> {
        ProxySpecBuilder builder;

        GitProxyNestedImpl(ProxySpec item) {
            this.builder = new ProxySpecBuilder(this, item);
        }

        GitProxyNestedImpl() {
            this.builder = new ProxySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluentImpl.this.withGitProxy(this.builder.build());
        }

        @Override
        public N endGitProxy() {
            return this.and();
        }
    }

    class DefaultProxyNestedImpl<N>
    extends ProxySpecFluentImpl<BuildDefaultsFluent.DefaultProxyNested<N>>
    implements BuildDefaultsFluent.DefaultProxyNested<N>,
    Nested<N> {
        ProxySpecBuilder builder;

        DefaultProxyNestedImpl(ProxySpec item) {
            this.builder = new ProxySpecBuilder(this, item);
        }

        DefaultProxyNestedImpl() {
            this.builder = new ProxySpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildDefaultsFluentImpl.this.withDefaultProxy(this.builder.build());
        }

        @Override
        public N endDefaultProxy() {
            return this.and();
        }
    }
}

