/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v6_7.dsl.internal;

import io.fabric8.kubernetes.api.model.v6_7.HasMetadata;
import io.fabric8.kubernetes.clnt.v6_7.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.clnt.v6_7.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WatcherWebSocketListener<T extends HasMetadata>
implements WebSocket.Listener {
    protected static final Logger logger = LoggerFactory.getLogger(WatcherWebSocketListener.class);
    protected final AbstractWatchManager.WatchRequestState state;
    protected final AbstractWatchManager<T> manager;

    protected WatcherWebSocketListener(AbstractWatchManager<T> manager, AbstractWatchManager.WatchRequestState state) {
        this.manager = manager;
        this.state = state;
    }

    public void onOpen(WebSocket webSocket) {
        logger.debug("WebSocket successfully opened");
        this.manager.resetReconnectAttempts(this.state);
    }

    public void onError(WebSocket webSocket, Throwable t) {
        this.manager.watchEnded(t, this.state);
    }

    public void onMessage(WebSocket webSocket, String text) {
        try {
            this.manager.onMessage(text, this.state);
        }
        finally {
            webSocket.request();
        }
    }

    public void onMessage(WebSocket webSocket, ByteBuffer bytes) {
        this.onMessage(webSocket, StandardCharsets.UTF_8.decode(bytes).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(WebSocket webSocket, int code, String reason) {
        logger.debug("WebSocket close received. code: {}, reason: {}", (Object)code, (Object)reason);
        try {
            webSocket.sendClose(code, reason);
        }
        finally {
            this.manager.watchEnded(null, this.state);
        }
    }
}

