/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.NodeSelector;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClass;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClassFluent;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClassParametersReference;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClassParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.resource.v1alpha1.ResourceClassParametersReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ResourceClassFluentImpl<A extends ResourceClassFluent<A>>
extends BaseFluent<A>
implements ResourceClassFluent<A> {
    private String apiVersion;
    private String driverName;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ResourceClassParametersReferenceBuilder parametersRef;
    private NodeSelector suitableNodes;
    private Map<String, Object> additionalProperties;

    public ResourceClassFluentImpl() {
    }

    public ResourceClassFluentImpl(ResourceClass instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverName(instance.getDriverName());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withParametersRef(instance.getParametersRef());
            this.withSuitableNodes(instance.getSuitableNodes());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getDriverName() {
        return this.driverName;
    }

    @Override
    public A withDriverName(String driverName) {
        this.driverName = driverName;
        return (A)this;
    }

    @Override
    public Boolean hasDriverName() {
        return this.driverName != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ResourceClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ResourceClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ResourceClassFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ResourceClassFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ResourceClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ResourceClassParametersReference getParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    @Override
    public ResourceClassParametersReference buildParametersRef() {
        return this.parametersRef != null ? this.parametersRef.build() : null;
    }

    @Override
    public A withParametersRef(ResourceClassParametersReference parametersRef) {
        this._visitables.get("parametersRef").remove(this.parametersRef);
        if (parametersRef != null) {
            this.parametersRef = new ResourceClassParametersReferenceBuilder(parametersRef);
            this._visitables.get("parametersRef").add(this.parametersRef);
        } else {
            this.parametersRef = null;
            this._visitables.get("parametersRef").remove(this.parametersRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasParametersRef() {
        return this.parametersRef != null;
    }

    @Override
    public A withNewParametersRef(String apiGroup, String kind, String name, String namespace) {
        return this.withParametersRef(new ResourceClassParametersReference(apiGroup, kind, name, namespace));
    }

    @Override
    public ResourceClassFluent.ParametersRefNested<A> withNewParametersRef() {
        return new ParametersRefNestedImpl();
    }

    @Override
    public ResourceClassFluent.ParametersRefNested<A> withNewParametersRefLike(ResourceClassParametersReference item) {
        return new ParametersRefNestedImpl(item);
    }

    @Override
    public ResourceClassFluent.ParametersRefNested<A> editParametersRef() {
        return this.withNewParametersRefLike(this.getParametersRef());
    }

    @Override
    public ResourceClassFluent.ParametersRefNested<A> editOrNewParametersRef() {
        return this.withNewParametersRefLike(this.getParametersRef() != null ? this.getParametersRef() : new ResourceClassParametersReferenceBuilder().build());
    }

    @Override
    public ResourceClassFluent.ParametersRefNested<A> editOrNewParametersRefLike(ResourceClassParametersReference item) {
        return this.withNewParametersRefLike(this.getParametersRef() != null ? this.getParametersRef() : item);
    }

    @Override
    public NodeSelector getSuitableNodes() {
        return this.suitableNodes;
    }

    @Override
    public A withSuitableNodes(NodeSelector suitableNodes) {
        this.suitableNodes = suitableNodes;
        return (A)this;
    }

    @Override
    public Boolean hasSuitableNodes() {
        return this.suitableNodes != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClassFluentImpl that = (ResourceClassFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverName, that.driverName)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.parametersRef, that.parametersRef)) {
            return false;
        }
        if (!Objects.equals(this.suitableNodes, that.suitableNodes)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.driverName, this.kind, this.metadata, this.parametersRef, this.suitableNodes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverName != null) {
            sb.append("driverName:");
            sb.append(this.driverName + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.parametersRef != null) {
            sb.append("parametersRef:");
            sb.append(this.parametersRef + ",");
        }
        if (this.suitableNodes != null) {
            sb.append("suitableNodes:");
            sb.append(this.suitableNodes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ParametersRefNestedImpl<N>
    extends ResourceClassParametersReferenceFluentImpl<ResourceClassFluent.ParametersRefNested<N>>
    implements ResourceClassFluent.ParametersRefNested<N>,
    Nested<N> {
        ResourceClassParametersReferenceBuilder builder;

        ParametersRefNestedImpl(ResourceClassParametersReference item) {
            this.builder = new ResourceClassParametersReferenceBuilder(this, item);
        }

        ParametersRefNestedImpl() {
            this.builder = new ResourceClassParametersReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceClassFluentImpl.this.withParametersRef(this.builder.build());
        }

        @Override
        public N endParametersRef() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ResourceClassFluent.MetadataNested<N>>
    implements ResourceClassFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ResourceClassFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

