/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.NonResourceAttributes;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.NonResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.NonResourceAttributesFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.ResourceAttributes;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.ResourceAttributesBuilder;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.ResourceAttributesFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.SubjectAccessReviewSpec;
import io.fabric8.kubernetes.api.model.v6_7.authorization.v1beta1.SubjectAccessReviewSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class SubjectAccessReviewSpecFluentImpl<A extends SubjectAccessReviewSpecFluent<A>>
extends BaseFluent<A>
implements SubjectAccessReviewSpecFluent<A> {
    private Map<String, ArrayList<String>> extra;
    private List<String> group = new ArrayList<String>();
    private NonResourceAttributesBuilder nonResourceAttributes;
    private ResourceAttributesBuilder resourceAttributes;
    private String uid;
    private String user;
    private Map<String, Object> additionalProperties;

    public SubjectAccessReviewSpecFluentImpl() {
    }

    public SubjectAccessReviewSpecFluentImpl(SubjectAccessReviewSpec instance) {
        if (instance != null) {
            this.withExtra(instance.getExtra());
            this.withGroup(instance.getGroup());
            this.withNonResourceAttributes(instance.getNonResourceAttributes());
            this.withResourceAttributes(instance.getResourceAttributes());
            this.withUid(instance.getUid());
            this.withUser(instance.getUser());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToExtra(String key, ArrayList<String> value) {
        if (this.extra == null && key != null && value != null) {
            this.extra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (key != null && value != null) {
            this.extra.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtra(Map<String, ArrayList<String>> map) {
        if (this.extra == null && map != null) {
            this.extra = new LinkedHashMap<String, ArrayList<String>>();
        }
        if (map != null) {
            this.extra.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(String key) {
        if (this.extra == null) {
            return (A)this;
        }
        if (key != null && this.extra != null) {
            this.extra.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtra(Map<String, ArrayList<String>> map) {
        if (this.extra == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extra == null) continue;
                this.extra.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, ArrayList<String>> getExtra() {
        return this.extra;
    }

    @Override
    public <K, V> A withExtra(Map<String, ArrayList<String>> extra) {
        this.extra = extra == null ? null : new LinkedHashMap<String, ArrayList<String>>(extra);
        return (A)this;
    }

    @Override
    public Boolean hasExtra() {
        return this.extra != null;
    }

    @Override
    public A addToGroup(int index, String item) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGroup(int index, String item) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        this.group.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGroup(String ... items) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        for (String item : items) {
            this.group.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroup(Collection<String> items) {
        if (this.group == null) {
            this.group = new ArrayList<String>();
        }
        for (String item : items) {
            this.group.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroup(String ... items) {
        for (String item : items) {
            if (this.group == null) continue;
            this.group.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroup(Collection<String> items) {
        for (String item : items) {
            if (this.group == null) continue;
            this.group.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGroup() {
        return this.group;
    }

    @Override
    public String getGroup(int index) {
        return this.group.get(index);
    }

    @Override
    public String getFirstGroup() {
        return this.group.get(0);
    }

    @Override
    public String getLastGroup() {
        return this.group.get(this.group.size() - 1);
    }

    @Override
    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item : this.group) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item : this.group) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroup(List<String> group) {
        if (group != null) {
            this.group = new ArrayList<String>();
            for (String item : group) {
                this.addToGroup(item);
            }
        } else {
            this.group = null;
        }
        return (A)this;
    }

    @Override
    public A withGroup(String ... group) {
        if (this.group != null) {
            this.group.clear();
            this._visitables.remove("group");
        }
        if (group != null) {
            for (String item : group) {
                this.addToGroup(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    @Override
    @Deprecated
    public NonResourceAttributes getNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public NonResourceAttributes buildNonResourceAttributes() {
        return this.nonResourceAttributes != null ? this.nonResourceAttributes.build() : null;
    }

    @Override
    public A withNonResourceAttributes(NonResourceAttributes nonResourceAttributes) {
        this._visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
        if (nonResourceAttributes != null) {
            this.nonResourceAttributes = new NonResourceAttributesBuilder(nonResourceAttributes);
            this._visitables.get("nonResourceAttributes").add(this.nonResourceAttributes);
        } else {
            this.nonResourceAttributes = null;
            this._visitables.get("nonResourceAttributes").remove(this.nonResourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNonResourceAttributes() {
        return this.nonResourceAttributes != null;
    }

    @Override
    public A withNewNonResourceAttributes(String path, String verb) {
        return this.withNonResourceAttributes(new NonResourceAttributes(path, verb));
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributes() {
        return new NonResourceAttributesNestedImpl();
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> withNewNonResourceAttributesLike(NonResourceAttributes item) {
        return new NonResourceAttributesNestedImpl(item);
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes());
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributes() {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : new NonResourceAttributesBuilder().build());
    }

    @Override
    public SubjectAccessReviewSpecFluent.NonResourceAttributesNested<A> editOrNewNonResourceAttributesLike(NonResourceAttributes item) {
        return this.withNewNonResourceAttributesLike(this.getNonResourceAttributes() != null ? this.getNonResourceAttributes() : item);
    }

    @Override
    @Deprecated
    public ResourceAttributes getResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public ResourceAttributes buildResourceAttributes() {
        return this.resourceAttributes != null ? this.resourceAttributes.build() : null;
    }

    @Override
    public A withResourceAttributes(ResourceAttributes resourceAttributes) {
        this._visitables.get("resourceAttributes").remove(this.resourceAttributes);
        if (resourceAttributes != null) {
            this.resourceAttributes = new ResourceAttributesBuilder(resourceAttributes);
            this._visitables.get("resourceAttributes").add(this.resourceAttributes);
        } else {
            this.resourceAttributes = null;
            this._visitables.get("resourceAttributes").remove(this.resourceAttributes);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceAttributes() {
        return this.resourceAttributes != null;
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributes() {
        return new ResourceAttributesNestedImpl();
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> withNewResourceAttributesLike(ResourceAttributes item) {
        return new ResourceAttributesNestedImpl(item);
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes());
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributes() {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : new ResourceAttributesBuilder().build());
    }

    @Override
    public SubjectAccessReviewSpecFluent.ResourceAttributesNested<A> editOrNewResourceAttributesLike(ResourceAttributes item) {
        return this.withNewResourceAttributesLike(this.getResourceAttributes() != null ? this.getResourceAttributes() : item);
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public A withUser(String user) {
        this.user = user;
        return (A)this;
    }

    @Override
    public Boolean hasUser() {
        return this.user != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectAccessReviewSpecFluentImpl that = (SubjectAccessReviewSpecFluentImpl)o;
        if (!Objects.equals(this.extra, that.extra)) {
            return false;
        }
        if (!Objects.equals(this.group, that.group)) {
            return false;
        }
        if (!Objects.equals(this.nonResourceAttributes, that.nonResourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.resourceAttributes, that.resourceAttributes)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        if (!Objects.equals(this.user, that.user)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.extra, this.group, this.nonResourceAttributes, this.resourceAttributes, this.uid, this.user, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.extra != null && !this.extra.isEmpty()) {
            sb.append("extra:");
            sb.append(this.extra + ",");
        }
        if (this.group != null && !this.group.isEmpty()) {
            sb.append("group:");
            sb.append(this.group + ",");
        }
        if (this.nonResourceAttributes != null) {
            sb.append("nonResourceAttributes:");
            sb.append(this.nonResourceAttributes + ",");
        }
        if (this.resourceAttributes != null) {
            sb.append("resourceAttributes:");
            sb.append(this.resourceAttributes + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.user != null) {
            sb.append("user:");
            sb.append(this.user + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ResourceAttributesNestedImpl<N>
    extends ResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>>
    implements SubjectAccessReviewSpecFluent.ResourceAttributesNested<N>,
    Nested<N> {
        ResourceAttributesBuilder builder;

        ResourceAttributesNestedImpl(ResourceAttributes item) {
            this.builder = new ResourceAttributesBuilder(this, item);
        }

        ResourceAttributesNestedImpl() {
            this.builder = new ResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluentImpl.this.withResourceAttributes(this.builder.build());
        }

        @Override
        public N endResourceAttributes() {
            return this.and();
        }
    }

    class NonResourceAttributesNestedImpl<N>
    extends NonResourceAttributesFluentImpl<SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>>
    implements SubjectAccessReviewSpecFluent.NonResourceAttributesNested<N>,
    Nested<N> {
        NonResourceAttributesBuilder builder;

        NonResourceAttributesNestedImpl(NonResourceAttributes item) {
            this.builder = new NonResourceAttributesBuilder(this, item);
        }

        NonResourceAttributesNestedImpl() {
            this.builder = new NonResourceAttributesBuilder(this);
        }

        @Override
        public N and() {
            return (N)SubjectAccessReviewSpecFluentImpl.this.withNonResourceAttributes(this.builder.build());
        }

        @Override
        public N endNonResourceAttributes() {
            return this.and();
        }
    }
}

