/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.apps;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.apps.Deployment;
import io.fabric8.kubernetes.api.model.v6_7.apps.DeploymentFluent;
import io.fabric8.kubernetes.api.model.v6_7.apps.DeploymentFluentImpl;

public class DeploymentBuilder
extends DeploymentFluentImpl<DeploymentBuilder>
implements VisitableBuilder<Deployment, DeploymentBuilder> {
    DeploymentFluent<?> fluent;
    Boolean validationEnabled;

    public DeploymentBuilder() {
        this(false);
    }

    public DeploymentBuilder(Boolean validationEnabled) {
        this(new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Deployment(), validationEnabled);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance) {
        this(fluent, instance, false);
    }

    public DeploymentBuilder(DeploymentFluent<?> fluent, Deployment instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSpec(instance.getSpec());
            fluent.withStatus(instance.getStatus());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public DeploymentBuilder(Deployment instance) {
        this(instance, (Boolean)false);
    }

    public DeploymentBuilder(Deployment instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Deployment build() {
        Deployment buildable = new Deployment(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

