/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.VolumeDevice;
import io.fabric8.kubernetes.api.model.v6_7.VolumeDeviceFluent;
import io.fabric8.kubernetes.api.model.v6_7.VolumeDeviceFluentImpl;

public class VolumeDeviceBuilder
extends VolumeDeviceFluentImpl<VolumeDeviceBuilder>
implements VisitableBuilder<VolumeDevice, VolumeDeviceBuilder> {
    VolumeDeviceFluent<?> fluent;
    Boolean validationEnabled;

    public VolumeDeviceBuilder() {
        this(false);
    }

    public VolumeDeviceBuilder(Boolean validationEnabled) {
        this(new VolumeDevice(), validationEnabled);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new VolumeDevice(), validationEnabled);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent, VolumeDevice instance) {
        this(fluent, instance, false);
    }

    public VolumeDeviceBuilder(VolumeDeviceFluent<?> fluent, VolumeDevice instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withDevicePath(instance.getDevicePath());
            fluent.withName(instance.getName());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public VolumeDeviceBuilder(VolumeDevice instance) {
        this(instance, (Boolean)false);
    }

    public VolumeDeviceBuilder(VolumeDevice instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withDevicePath(instance.getDevicePath());
            this.withName(instance.getName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public VolumeDevice build() {
        VolumeDevice buildable = new VolumeDevice(this.fluent.getDevicePath(), this.fluent.getName());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

