/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ServiceAccount;
import io.fabric8.kubernetes.api.model.v6_7.ServiceAccountFluent;
import io.fabric8.kubernetes.api.model.v6_7.ServiceAccountFluentImpl;

public class ServiceAccountBuilder
extends ServiceAccountFluentImpl<ServiceAccountBuilder>
implements VisitableBuilder<ServiceAccount, ServiceAccountBuilder> {
    ServiceAccountFluent<?> fluent;
    Boolean validationEnabled;

    public ServiceAccountBuilder() {
        this(false);
    }

    public ServiceAccountBuilder(Boolean validationEnabled) {
        this(new ServiceAccount(), validationEnabled);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ServiceAccount(), validationEnabled);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent, ServiceAccount instance) {
        this(fluent, instance, false);
    }

    public ServiceAccountBuilder(ServiceAccountFluent<?> fluent, ServiceAccount instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            fluent.withImagePullSecrets(instance.getImagePullSecrets());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withSecrets(instance.getSecrets());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ServiceAccountBuilder(ServiceAccount instance) {
        this(instance, (Boolean)false);
    }

    public ServiceAccountBuilder(ServiceAccount instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withAutomountServiceAccountToken(instance.getAutomountServiceAccountToken());
            this.withImagePullSecrets(instance.getImagePullSecrets());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSecrets(instance.getSecrets());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ServiceAccount build() {
        ServiceAccount buildable = new ServiceAccount(this.fluent.getApiVersion(), this.fluent.getAutomountServiceAccountToken(), this.fluent.getImagePullSecrets(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSecrets());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

