/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.ClaimSource;
import io.fabric8.kubernetes.api.model.v6_7.ClaimSourceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ClaimSourceFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.PodResourceClaim;
import io.fabric8.kubernetes.api.model.v6_7.PodResourceClaimFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class PodResourceClaimFluentImpl<A extends PodResourceClaimFluent<A>>
extends BaseFluent<A>
implements PodResourceClaimFluent<A> {
    private String name;
    private ClaimSourceBuilder source;
    private Map<String, Object> additionalProperties;

    public PodResourceClaimFluentImpl() {
    }

    public PodResourceClaimFluentImpl(PodResourceClaim instance) {
        if (instance != null) {
            this.withName(instance.getName());
            this.withSource(instance.getSource());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public ClaimSource getSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public ClaimSource buildSource() {
        return this.source != null ? this.source.build() : null;
    }

    @Override
    public A withSource(ClaimSource source) {
        this._visitables.get("source").remove(this.source);
        if (source != null) {
            this.source = new ClaimSourceBuilder(source);
            this._visitables.get("source").add(this.source);
        } else {
            this.source = null;
            this._visitables.get("source").remove(this.source);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSource() {
        return this.source != null;
    }

    @Override
    public A withNewSource(String resourceClaimName, String resourceClaimTemplateName) {
        return this.withSource(new ClaimSource(resourceClaimName, resourceClaimTemplateName));
    }

    @Override
    public PodResourceClaimFluent.SourceNested<A> withNewSource() {
        return new SourceNestedImpl();
    }

    @Override
    public PodResourceClaimFluent.SourceNested<A> withNewSourceLike(ClaimSource item) {
        return new SourceNestedImpl(item);
    }

    @Override
    public PodResourceClaimFluent.SourceNested<A> editSource() {
        return this.withNewSourceLike(this.getSource());
    }

    @Override
    public PodResourceClaimFluent.SourceNested<A> editOrNewSource() {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : new ClaimSourceBuilder().build());
    }

    @Override
    public PodResourceClaimFluent.SourceNested<A> editOrNewSourceLike(ClaimSource item) {
        return this.withNewSourceLike(this.getSource() != null ? this.getSource() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodResourceClaimFluentImpl that = (PodResourceClaimFluentImpl)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.source, that.source)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.source, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.source != null) {
            sb.append("source:");
            sb.append(this.source + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SourceNestedImpl<N>
    extends ClaimSourceFluentImpl<PodResourceClaimFluent.SourceNested<N>>
    implements PodResourceClaimFluent.SourceNested<N>,
    Nested<N> {
        ClaimSourceBuilder builder;

        SourceNestedImpl(ClaimSource item) {
            this.builder = new ClaimSourceBuilder(this, item);
        }

        SourceNestedImpl() {
            this.builder = new ClaimSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodResourceClaimFluentImpl.this.withSource(this.builder.build());
        }

        @Override
        public N endSource() {
            return this.and();
        }
    }
}

