/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ContainerStatus;
import io.fabric8.kubernetes.api.model.v6_7.ContainerStatusFluent;
import io.fabric8.kubernetes.api.model.v6_7.ContainerStatusFluentImpl;

public class ContainerStatusBuilder
extends ContainerStatusFluentImpl<ContainerStatusBuilder>
implements VisitableBuilder<ContainerStatus, ContainerStatusBuilder> {
    ContainerStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStatusBuilder() {
        this(false);
    }

    public ContainerStatusBuilder(Boolean validationEnabled) {
        this(new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerStatus(), validationEnabled);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance) {
        this(fluent, instance, false);
    }

    public ContainerStatusBuilder(ContainerStatusFluent<?> fluent, ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withContainerID(instance.getContainerID());
            fluent.withImage(instance.getImage());
            fluent.withImageID(instance.getImageID());
            fluent.withLastState(instance.getLastState());
            fluent.withName(instance.getName());
            fluent.withReady(instance.getReady());
            fluent.withRestartCount(instance.getRestartCount());
            fluent.withStarted(instance.getStarted());
            fluent.withState(instance.getState());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ContainerStatusBuilder(ContainerStatus instance) {
        this(instance, (Boolean)false);
    }

    public ContainerStatusBuilder(ContainerStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withContainerID(instance.getContainerID());
            this.withImage(instance.getImage());
            this.withImageID(instance.getImageID());
            this.withLastState(instance.getLastState());
            this.withName(instance.getName());
            this.withReady(instance.getReady());
            this.withRestartCount(instance.getRestartCount());
            this.withStarted(instance.getStarted());
            this.withState(instance.getState());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerStatus build() {
        ContainerStatus buildable = new ContainerStatus(this.fluent.getContainerID(), this.fluent.getImage(), this.fluent.getImageID(), this.fluent.getLastState(), this.fluent.getName(), this.fluent.getReady(), this.fluent.getRestartCount(), this.fluent.getStarted(), this.fluent.getState());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

