/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ContainerPort;
import io.fabric8.kubernetes.api.model.v6_7.ContainerPortFluent;
import io.fabric8.kubernetes.api.model.v6_7.ContainerPortFluentImpl;

public class ContainerPortBuilder
extends ContainerPortFluentImpl<ContainerPortBuilder>
implements VisitableBuilder<ContainerPort, ContainerPortBuilder> {
    ContainerPortFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerPortBuilder() {
        this(false);
    }

    public ContainerPortBuilder(Boolean validationEnabled) {
        this(new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerPort(), validationEnabled);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance) {
        this(fluent, instance, false);
    }

    public ContainerPortBuilder(ContainerPortFluent<?> fluent, ContainerPort instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withContainerPort(instance.getContainerPort());
            fluent.withHostIP(instance.getHostIP());
            fluent.withHostPort(instance.getHostPort());
            fluent.withName(instance.getName());
            fluent.withProtocol(instance.getProtocol());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ContainerPortBuilder(ContainerPort instance) {
        this(instance, (Boolean)false);
    }

    public ContainerPortBuilder(ContainerPort instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withContainerPort(instance.getContainerPort());
            this.withHostIP(instance.getHostIP());
            this.withHostPort(instance.getHostPort());
            this.withName(instance.getName());
            this.withProtocol(instance.getProtocol());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerPort build() {
        ContainerPort buildable = new ContainerPort(this.fluent.getContainerPort(), this.fluent.getHostIP(), this.fluent.getHostPort(), this.fluent.getName(), this.fluent.getProtocol());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

