/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_7.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_7.LabelSelectorFluentImpl;
import io.fabric8.openshift.api.model.v6_7.operatorhub.v1.OperatorGroupSpec;
import io.fabric8.openshift.api.model.v6_7.operatorhub.v1.OperatorGroupSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorGroupSpecFluentImpl<A extends OperatorGroupSpecFluent<A>>
extends BaseFluent<A>
implements OperatorGroupSpecFluent<A> {
    private LabelSelectorBuilder selector;
    private String serviceAccountName;
    private Boolean staticProvidedAPIs;
    private List<String> targetNamespaces = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public OperatorGroupSpecFluentImpl() {
    }

    public OperatorGroupSpecFluentImpl(OperatorGroupSpec instance) {
        if (instance != null) {
            this.withSelector(instance.getSelector());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withStaticProvidedAPIs(instance.getStaticProvidedAPIs());
            this.withTargetNamespaces(instance.getTargetNamespaces());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public LabelSelector getSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public LabelSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    @Override
    public A withSelector(LabelSelector selector) {
        this._visitables.get("selector").remove(this.selector);
        if (selector != null) {
            this.selector = new LabelSelectorBuilder(selector);
            this._visitables.get("selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get("selector").remove(this.selector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSelector() {
        return this.selector != null;
    }

    @Override
    public OperatorGroupSpecFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    @Override
    public OperatorGroupSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    @Override
    public OperatorGroupSpecFluent.SelectorNested<A> editSelector() {
        return this.withNewSelectorLike(this.getSelector());
    }

    @Override
    public OperatorGroupSpecFluent.SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public OperatorGroupSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return this.withNewSelectorLike(this.getSelector() != null ? this.getSelector() : item);
    }

    @Override
    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    @Override
    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    @Override
    public Boolean getStaticProvidedAPIs() {
        return this.staticProvidedAPIs;
    }

    @Override
    public A withStaticProvidedAPIs(Boolean staticProvidedAPIs) {
        this.staticProvidedAPIs = staticProvidedAPIs;
        return (A)this;
    }

    @Override
    public Boolean hasStaticProvidedAPIs() {
        return this.staticProvidedAPIs != null;
    }

    @Override
    public A addToTargetNamespaces(int index, String item) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        this.targetNamespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTargetNamespaces(int index, String item) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        this.targetNamespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTargetNamespaces(String ... items) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetNamespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTargetNamespaces(Collection<String> items) {
        if (this.targetNamespaces == null) {
            this.targetNamespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.targetNamespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTargetNamespaces(String ... items) {
        for (String item : items) {
            if (this.targetNamespaces == null) continue;
            this.targetNamespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTargetNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.targetNamespaces == null) continue;
            this.targetNamespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getTargetNamespaces() {
        return this.targetNamespaces;
    }

    @Override
    public String getTargetNamespace(int index) {
        return this.targetNamespaces.get(index);
    }

    @Override
    public String getFirstTargetNamespace() {
        return this.targetNamespaces.get(0);
    }

    @Override
    public String getLastTargetNamespace() {
        return this.targetNamespaces.get(this.targetNamespaces.size() - 1);
    }

    @Override
    public String getMatchingTargetNamespace(Predicate<String> predicate) {
        for (String item : this.targetNamespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTargetNamespace(Predicate<String> predicate) {
        for (String item : this.targetNamespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTargetNamespaces(List<String> targetNamespaces) {
        if (targetNamespaces != null) {
            this.targetNamespaces = new ArrayList<String>();
            for (String item : targetNamespaces) {
                this.addToTargetNamespaces(item);
            }
        } else {
            this.targetNamespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withTargetNamespaces(String ... targetNamespaces) {
        if (this.targetNamespaces != null) {
            this.targetNamespaces.clear();
            this._visitables.remove("targetNamespaces");
        }
        if (targetNamespaces != null) {
            for (String item : targetNamespaces) {
                this.addToTargetNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetNamespaces() {
        return this.targetNamespaces != null && !this.targetNamespaces.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OperatorGroupSpecFluentImpl that = (OperatorGroupSpecFluentImpl)o;
        if (!Objects.equals(this.selector, that.selector)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.staticProvidedAPIs, that.staticProvidedAPIs)) {
            return false;
        }
        if (!Objects.equals(this.targetNamespaces, that.targetNamespaces)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.selector, this.serviceAccountName, this.staticProvidedAPIs, this.targetNamespaces, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.selector != null) {
            sb.append("selector:");
            sb.append(this.selector + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.staticProvidedAPIs != null) {
            sb.append("staticProvidedAPIs:");
            sb.append(this.staticProvidedAPIs + ",");
        }
        if (this.targetNamespaces != null && !this.targetNamespaces.isEmpty()) {
            sb.append("targetNamespaces:");
            sb.append(this.targetNamespaces + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withStaticProvidedAPIs() {
        return this.withStaticProvidedAPIs(true);
    }

    class SelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<OperatorGroupSpecFluent.SelectorNested<N>>
    implements OperatorGroupSpecFluent.SelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)OperatorGroupSpecFluentImpl.this.withSelector(this.builder.build());
        }

        @Override
        public N endSelector() {
            return this.and();
        }
    }
}

