/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServer;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServerFluent;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServerSpec;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServerSpecBuilder;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServerSpecFluentImpl;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServerStatus;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServerStatusBuilder;
import io.fabric8.openshift.api.model.v6_7.operator.v1.OpenShiftAPIServerStatusFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class OpenShiftAPIServerFluentImpl<A extends OpenShiftAPIServerFluent<A>>
extends BaseFluent<A>
implements OpenShiftAPIServerFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private OpenShiftAPIServerSpecBuilder spec;
    private OpenShiftAPIServerStatusBuilder status;
    private Map<String, Object> additionalProperties;

    public OpenShiftAPIServerFluentImpl() {
    }

    public OpenShiftAPIServerFluentImpl(OpenShiftAPIServer instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public OpenShiftAPIServerFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public OpenShiftAPIServerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public OpenShiftAPIServerFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public OpenShiftAPIServerFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public OpenShiftAPIServerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public OpenShiftAPIServerSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public OpenShiftAPIServerSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(OpenShiftAPIServerSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new OpenShiftAPIServerSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public OpenShiftAPIServerFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public OpenShiftAPIServerFluent.SpecNested<A> withNewSpecLike(OpenShiftAPIServerSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public OpenShiftAPIServerFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public OpenShiftAPIServerFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new OpenShiftAPIServerSpecBuilder().build());
    }

    @Override
    public OpenShiftAPIServerFluent.SpecNested<A> editOrNewSpecLike(OpenShiftAPIServerSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public OpenShiftAPIServerStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public OpenShiftAPIServerStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(OpenShiftAPIServerStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new OpenShiftAPIServerStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public OpenShiftAPIServerFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public OpenShiftAPIServerFluent.StatusNested<A> withNewStatusLike(OpenShiftAPIServerStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public OpenShiftAPIServerFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public OpenShiftAPIServerFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new OpenShiftAPIServerStatusBuilder().build());
    }

    @Override
    public OpenShiftAPIServerFluent.StatusNested<A> editOrNewStatusLike(OpenShiftAPIServerStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenShiftAPIServerFluentImpl that = (OpenShiftAPIServerFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends OpenShiftAPIServerStatusFluentImpl<OpenShiftAPIServerFluent.StatusNested<N>>
    implements OpenShiftAPIServerFluent.StatusNested<N>,
    Nested<N> {
        OpenShiftAPIServerStatusBuilder builder;

        StatusNestedImpl(OpenShiftAPIServerStatus item) {
            this.builder = new OpenShiftAPIServerStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new OpenShiftAPIServerStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpenShiftAPIServerFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends OpenShiftAPIServerSpecFluentImpl<OpenShiftAPIServerFluent.SpecNested<N>>
    implements OpenShiftAPIServerFluent.SpecNested<N>,
    Nested<N> {
        OpenShiftAPIServerSpecBuilder builder;

        SpecNestedImpl(OpenShiftAPIServerSpec item) {
            this.builder = new OpenShiftAPIServerSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new OpenShiftAPIServerSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpenShiftAPIServerFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<OpenShiftAPIServerFluent.MetadataNested<N>>
    implements OpenShiftAPIServerFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpenShiftAPIServerFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

