/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.IntOrString;
import io.fabric8.kubernetes.api.model.v6_7.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.v6_7.IntOrStringFluentImpl;
import io.fabric8.openshift.api.model.v6_7.monitoring.v1.Rule;
import io.fabric8.openshift.api.model.v6_7.monitoring.v1.RuleFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class RuleFluentImpl<A extends RuleFluent<A>>
extends BaseFluent<A>
implements RuleFluent<A> {
    private String alert;
    private Map<String, String> annotations;
    private IntOrStringBuilder expr;
    private String _for;
    private Map<String, String> labels;
    private String record;
    private Map<String, Object> additionalProperties;

    public RuleFluentImpl() {
    }

    public RuleFluentImpl(Rule instance) {
        if (instance != null) {
            this.withAlert(instance.getAlert());
            this.withAnnotations(instance.getAnnotations());
            this.withExpr(instance.getExpr());
            this.withFor(instance.getFor());
            this.withLabels(instance.getLabels());
            this.withRecord(instance.getRecord());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getAlert() {
        return this.alert;
    }

    @Override
    public A withAlert(String alert) {
        this.alert = alert;
        return (A)this;
    }

    @Override
    public Boolean hasAlert() {
        return this.alert != null;
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    @Deprecated
    public IntOrString getExpr() {
        return this.expr != null ? this.expr.build() : null;
    }

    @Override
    public IntOrString buildExpr() {
        return this.expr != null ? this.expr.build() : null;
    }

    @Override
    public A withExpr(IntOrString expr) {
        this._visitables.get("expr").remove(this.expr);
        if (expr != null) {
            this.expr = new IntOrStringBuilder(expr);
            this._visitables.get("expr").add(this.expr);
        } else {
            this.expr = null;
            this._visitables.get("expr").remove(this.expr);
        }
        return (A)this;
    }

    @Override
    public Boolean hasExpr() {
        return this.expr != null;
    }

    @Override
    public A withNewExpr(Object value) {
        return this.withExpr(new IntOrString(value));
    }

    @Override
    public RuleFluent.ExprNested<A> withNewExpr() {
        return new ExprNestedImpl();
    }

    @Override
    public RuleFluent.ExprNested<A> withNewExprLike(IntOrString item) {
        return new ExprNestedImpl(item);
    }

    @Override
    public RuleFluent.ExprNested<A> editExpr() {
        return this.withNewExprLike(this.getExpr());
    }

    @Override
    public RuleFluent.ExprNested<A> editOrNewExpr() {
        return this.withNewExprLike(this.getExpr() != null ? this.getExpr() : new IntOrStringBuilder().build());
    }

    @Override
    public RuleFluent.ExprNested<A> editOrNewExprLike(IntOrString item) {
        return this.withNewExprLike(this.getExpr() != null ? this.getExpr() : item);
    }

    @Override
    public String getFor() {
        return this._for;
    }

    @Override
    public A withFor(String _for) {
        this._for = _for;
        return (A)this;
    }

    @Override
    public Boolean hasFor() {
        return this._for != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public String getRecord() {
        return this.record;
    }

    @Override
    public A withRecord(String record) {
        this.record = record;
        return (A)this;
    }

    @Override
    public Boolean hasRecord() {
        return this.record != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuleFluentImpl that = (RuleFluentImpl)o;
        if (!Objects.equals(this.alert, that.alert)) {
            return false;
        }
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.expr, that.expr)) {
            return false;
        }
        if (!Objects.equals(this._for, that._for)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.record, that.record)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.alert, this.annotations, this.expr, this._for, this.labels, this.record, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.alert != null) {
            sb.append("alert:");
            sb.append(this.alert + ",");
        }
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.expr != null) {
            sb.append("expr:");
            sb.append(this.expr + ",");
        }
        if (this._for != null) {
            sb.append("_for:");
            sb.append(this._for + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.record != null) {
            sb.append("record:");
            sb.append(this.record + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ExprNestedImpl<N>
    extends IntOrStringFluentImpl<RuleFluent.ExprNested<N>>
    implements RuleFluent.ExprNested<N>,
    Nested<N> {
        IntOrStringBuilder builder;

        ExprNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        ExprNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        @Override
        public N and() {
            return (N)RuleFluentImpl.this.withExpr(this.builder.build());
        }

        @Override
        public N endExpr() {
            return this.and();
        }
    }
}

