/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.hive.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.openshift.api.model.v6_7.hive.v1.HiveConfigCondition;
import io.fabric8.openshift.api.model.v6_7.hive.v1.HiveConfigConditionBuilder;
import io.fabric8.openshift.api.model.v6_7.hive.v1.HiveConfigConditionFluentImpl;
import io.fabric8.openshift.api.model.v6_7.hive.v1.HiveConfigStatus;
import io.fabric8.openshift.api.model.v6_7.hive.v1.HiveConfigStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HiveConfigStatusFluentImpl<A extends HiveConfigStatusFluent<A>>
extends BaseFluent<A>
implements HiveConfigStatusFluent<A> {
    private String aggregatorClientCAHash;
    private ArrayList<HiveConfigConditionBuilder> conditions = new ArrayList();
    private Boolean configApplied;
    private Long observedGeneration;
    private Map<String, Object> additionalProperties;

    public HiveConfigStatusFluentImpl() {
    }

    public HiveConfigStatusFluentImpl(HiveConfigStatus instance) {
        if (instance != null) {
            this.withAggregatorClientCAHash(instance.getAggregatorClientCAHash());
            this.withConditions(instance.getConditions());
            this.withConfigApplied(instance.getConfigApplied());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getAggregatorClientCAHash() {
        return this.aggregatorClientCAHash;
    }

    @Override
    public A withAggregatorClientCAHash(String aggregatorClientCAHash) {
        this.aggregatorClientCAHash = aggregatorClientCAHash;
        return (A)this;
    }

    @Override
    public Boolean hasAggregatorClientCAHash() {
        return this.aggregatorClientCAHash != null;
    }

    @Override
    public A addToConditions(int index, HiveConfigCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").add(index, builder);
            this.conditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToConditions(int index, HiveConfigCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);
        if (index < 0 || index >= this.conditions.size()) {
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(HiveConfigCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HiveConfigCondition item : items) {
            HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<HiveConfigCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList();
        }
        for (HiveConfigCondition item : items) {
            HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(HiveConfigCondition ... items) {
        for (HiveConfigCondition item : items) {
            HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<HiveConfigCondition> items) {
        for (HiveConfigCondition item : items) {
            HiveConfigConditionBuilder builder = new HiveConfigConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<HiveConfigConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<HiveConfigConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            HiveConfigConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<HiveConfigCondition> getConditions() {
        return this.conditions != null ? HiveConfigStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public List<HiveConfigCondition> buildConditions() {
        return this.conditions != null ? HiveConfigStatusFluentImpl.build(this.conditions) : null;
    }

    @Override
    public HiveConfigCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public HiveConfigCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public HiveConfigCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public HiveConfigCondition buildMatchingCondition(Predicate<HiveConfigConditionBuilder> predicate) {
        for (HiveConfigConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<HiveConfigConditionBuilder> predicate) {
        for (HiveConfigConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<HiveConfigCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").clear();
        }
        if (conditions != null) {
            this.conditions = new ArrayList();
            for (HiveConfigCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(HiveConfigCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove("conditions");
        }
        if (conditions != null) {
            for (HiveConfigCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public HiveConfigStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public HiveConfigStatusFluent.ConditionsNested<A> addNewConditionLike(HiveConfigCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public HiveConfigStatusFluent.ConditionsNested<A> setNewConditionLike(int index, HiveConfigCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public HiveConfigStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public HiveConfigStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public HiveConfigStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public HiveConfigStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<HiveConfigConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Boolean getConfigApplied() {
        return this.configApplied;
    }

    @Override
    public A withConfigApplied(Boolean configApplied) {
        this.configApplied = configApplied;
        return (A)this;
    }

    @Override
    public Boolean hasConfigApplied() {
        return this.configApplied != null;
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HiveConfigStatusFluentImpl that = (HiveConfigStatusFluentImpl)o;
        if (!Objects.equals(this.aggregatorClientCAHash, that.aggregatorClientCAHash)) {
            return false;
        }
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.configApplied, that.configApplied)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aggregatorClientCAHash, this.conditions, this.configApplied, this.observedGeneration, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aggregatorClientCAHash != null) {
            sb.append("aggregatorClientCAHash:");
            sb.append(this.aggregatorClientCAHash + ",");
        }
        if (this.conditions != null) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.configApplied != null) {
            sb.append("configApplied:");
            sb.append(this.configApplied + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withConfigApplied() {
        return this.withConfigApplied(true);
    }

    class ConditionsNestedImpl<N>
    extends HiveConfigConditionFluentImpl<HiveConfigStatusFluent.ConditionsNested<N>>
    implements HiveConfigStatusFluent.ConditionsNested<N>,
    Nested<N> {
        HiveConfigConditionBuilder builder;
        int index;

        ConditionsNestedImpl(int index, HiveConfigCondition item) {
            this.index = index;
            this.builder = new HiveConfigConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new HiveConfigConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)HiveConfigStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

