/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.hive.openstack.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.openshift.api.model.v6_7.hive.openstack.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_7.hive.openstack.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_7.hive.openstack.v1.RootVolume;
import io.fabric8.openshift.api.model.v6_7.hive.openstack.v1.RootVolumeBuilder;
import io.fabric8.openshift.api.model.v6_7.hive.openstack.v1.RootVolumeFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>>
extends BaseFluent<A>
implements MachinePoolFluent<A> {
    private String flavor;
    private RootVolumeBuilder rootVolume;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluentImpl() {
    }

    public MachinePoolFluentImpl(MachinePool instance) {
        if (instance != null) {
            this.withFlavor(instance.getFlavor());
            this.withRootVolume(instance.getRootVolume());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getFlavor() {
        return this.flavor;
    }

    @Override
    public A withFlavor(String flavor) {
        this.flavor = flavor;
        return (A)this;
    }

    @Override
    public Boolean hasFlavor() {
        return this.flavor != null;
    }

    @Override
    @Deprecated
    public RootVolume getRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    @Override
    public RootVolume buildRootVolume() {
        return this.rootVolume != null ? this.rootVolume.build() : null;
    }

    @Override
    public A withRootVolume(RootVolume rootVolume) {
        this._visitables.get("rootVolume").remove(this.rootVolume);
        if (rootVolume != null) {
            this.rootVolume = new RootVolumeBuilder(rootVolume);
            this._visitables.get("rootVolume").add(this.rootVolume);
        } else {
            this.rootVolume = null;
            this._visitables.get("rootVolume").remove(this.rootVolume);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRootVolume() {
        return this.rootVolume != null;
    }

    @Override
    public A withNewRootVolume(Integer size, String type) {
        return this.withRootVolume(new RootVolume(size, type));
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> withNewRootVolume() {
        return new RootVolumeNestedImpl();
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> withNewRootVolumeLike(RootVolume item) {
        return new RootVolumeNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> editRootVolume() {
        return this.withNewRootVolumeLike(this.getRootVolume());
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> editOrNewRootVolume() {
        return this.withNewRootVolumeLike(this.getRootVolume() != null ? this.getRootVolume() : new RootVolumeBuilder().build());
    }

    @Override
    public MachinePoolFluent.RootVolumeNested<A> editOrNewRootVolumeLike(RootVolume item) {
        return this.withNewRootVolumeLike(this.getRootVolume() != null ? this.getRootVolume() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluentImpl that = (MachinePoolFluentImpl)o;
        if (!Objects.equals(this.flavor, that.flavor)) {
            return false;
        }
        if (!Objects.equals(this.rootVolume, that.rootVolume)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.flavor, this.rootVolume, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.flavor != null) {
            sb.append("flavor:");
            sb.append(this.flavor + ",");
        }
        if (this.rootVolume != null) {
            sb.append("rootVolume:");
            sb.append(this.rootVolume + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RootVolumeNestedImpl<N>
    extends RootVolumeFluentImpl<MachinePoolFluent.RootVolumeNested<N>>
    implements MachinePoolFluent.RootVolumeNested<N>,
    Nested<N> {
        RootVolumeBuilder builder;

        RootVolumeNestedImpl(RootVolume item) {
            this.builder = new RootVolumeBuilder(this, item);
        }

        RootVolumeNestedImpl() {
            this.builder = new RootVolumeBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withRootVolume(this.builder.build());
        }

        @Override
        public N endRootVolume() {
            return this.and();
        }
    }
}

