/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.config.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.openshift.api.model.v6_7.config.v1.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v6_7.config.v1.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v6_7.config.v1.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_7.config.v1.SchedulerSpec;
import io.fabric8.openshift.api.model.v6_7.config.v1.SchedulerSpecFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class SchedulerSpecFluentImpl<A extends SchedulerSpecFluent<A>>
extends BaseFluent<A>
implements SchedulerSpecFluent<A> {
    private String defaultNodeSelector;
    private Boolean mastersSchedulable;
    private ConfigMapNameReferenceBuilder policy;
    private String profile;
    private Map<String, Object> additionalProperties;

    public SchedulerSpecFluentImpl() {
    }

    public SchedulerSpecFluentImpl(SchedulerSpec instance) {
        if (instance != null) {
            this.withDefaultNodeSelector(instance.getDefaultNodeSelector());
            this.withMastersSchedulable(instance.getMastersSchedulable());
            this.withPolicy(instance.getPolicy());
            this.withProfile(instance.getProfile());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getDefaultNodeSelector() {
        return this.defaultNodeSelector;
    }

    @Override
    public A withDefaultNodeSelector(String defaultNodeSelector) {
        this.defaultNodeSelector = defaultNodeSelector;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultNodeSelector() {
        return this.defaultNodeSelector != null;
    }

    @Override
    public Boolean getMastersSchedulable() {
        return this.mastersSchedulable;
    }

    @Override
    public A withMastersSchedulable(Boolean mastersSchedulable) {
        this.mastersSchedulable = mastersSchedulable;
        return (A)this;
    }

    @Override
    public Boolean hasMastersSchedulable() {
        return this.mastersSchedulable != null;
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    @Override
    public ConfigMapNameReference buildPolicy() {
        return this.policy != null ? this.policy.build() : null;
    }

    @Override
    public A withPolicy(ConfigMapNameReference policy) {
        this._visitables.get("policy").remove(this.policy);
        if (policy != null) {
            this.policy = new ConfigMapNameReferenceBuilder(policy);
            this._visitables.get("policy").add(this.policy);
        } else {
            this.policy = null;
            this._visitables.get("policy").remove(this.policy);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPolicy() {
        return this.policy != null;
    }

    @Override
    public A withNewPolicy(String name) {
        return this.withPolicy(new ConfigMapNameReference(name));
    }

    @Override
    public SchedulerSpecFluent.PolicyNested<A> withNewPolicy() {
        return new PolicyNestedImpl();
    }

    @Override
    public SchedulerSpecFluent.PolicyNested<A> withNewPolicyLike(ConfigMapNameReference item) {
        return new PolicyNestedImpl(item);
    }

    @Override
    public SchedulerSpecFluent.PolicyNested<A> editPolicy() {
        return this.withNewPolicyLike(this.getPolicy());
    }

    @Override
    public SchedulerSpecFluent.PolicyNested<A> editOrNewPolicy() {
        return this.withNewPolicyLike(this.getPolicy() != null ? this.getPolicy() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public SchedulerSpecFluent.PolicyNested<A> editOrNewPolicyLike(ConfigMapNameReference item) {
        return this.withNewPolicyLike(this.getPolicy() != null ? this.getPolicy() : item);
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public A withProfile(String profile) {
        this.profile = profile;
        return (A)this;
    }

    @Override
    public Boolean hasProfile() {
        return this.profile != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SchedulerSpecFluentImpl that = (SchedulerSpecFluentImpl)o;
        if (!Objects.equals(this.defaultNodeSelector, that.defaultNodeSelector)) {
            return false;
        }
        if (!Objects.equals(this.mastersSchedulable, that.mastersSchedulable)) {
            return false;
        }
        if (!Objects.equals(this.policy, that.policy)) {
            return false;
        }
        if (!Objects.equals(this.profile, that.profile)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.defaultNodeSelector, this.mastersSchedulable, this.policy, this.profile, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.defaultNodeSelector != null) {
            sb.append("defaultNodeSelector:");
            sb.append(this.defaultNodeSelector + ",");
        }
        if (this.mastersSchedulable != null) {
            sb.append("mastersSchedulable:");
            sb.append(this.mastersSchedulable + ",");
        }
        if (this.policy != null) {
            sb.append("policy:");
            sb.append(this.policy + ",");
        }
        if (this.profile != null) {
            sb.append("profile:");
            sb.append(this.profile + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withMastersSchedulable() {
        return this.withMastersSchedulable(true);
    }

    class PolicyNestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<SchedulerSpecFluent.PolicyNested<N>>
    implements SchedulerSpecFluent.PolicyNested<N>,
    Nested<N> {
        ConfigMapNameReferenceBuilder builder;

        PolicyNestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        PolicyNestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)SchedulerSpecFluentImpl.this.withPolicy(this.builder.build());
        }

        @Override
        public N endPolicy() {
            return this.and();
        }
    }
}

