/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7.config.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.openshift.api.model.v6_7.config.v1.Release;
import io.fabric8.openshift.api.model.v6_7.config.v1.ReleaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ReleaseFluentImpl<A extends ReleaseFluent<A>>
extends BaseFluent<A>
implements ReleaseFluent<A> {
    private List<String> channels = new ArrayList<String>();
    private String image;
    private String url;
    private String version;
    private Map<String, Object> additionalProperties;

    public ReleaseFluentImpl() {
    }

    public ReleaseFluentImpl(Release instance) {
        if (instance != null) {
            this.withChannels(instance.getChannels());
            this.withImage(instance.getImage());
            this.withUrl(instance.getUrl());
            this.withVersion(instance.getVersion());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToChannels(int index, String item) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        this.channels.add(index, item);
        return (A)this;
    }

    @Override
    public A setToChannels(int index, String item) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        this.channels.set(index, item);
        return (A)this;
    }

    @Override
    public A addToChannels(String ... items) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        for (String item : items) {
            this.channels.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToChannels(Collection<String> items) {
        if (this.channels == null) {
            this.channels = new ArrayList<String>();
        }
        for (String item : items) {
            this.channels.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromChannels(String ... items) {
        for (String item : items) {
            if (this.channels == null) continue;
            this.channels.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromChannels(Collection<String> items) {
        for (String item : items) {
            if (this.channels == null) continue;
            this.channels.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    public String getChannel(int index) {
        return this.channels.get(index);
    }

    @Override
    public String getFirstChannel() {
        return this.channels.get(0);
    }

    @Override
    public String getLastChannel() {
        return this.channels.get(this.channels.size() - 1);
    }

    @Override
    public String getMatchingChannel(Predicate<String> predicate) {
        for (String item : this.channels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingChannel(Predicate<String> predicate) {
        for (String item : this.channels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withChannels(List<String> channels) {
        if (channels != null) {
            this.channels = new ArrayList<String>();
            for (String item : channels) {
                this.addToChannels(item);
            }
        } else {
            this.channels = null;
        }
        return (A)this;
    }

    @Override
    public A withChannels(String ... channels) {
        if (this.channels != null) {
            this.channels.clear();
            this._visitables.remove("channels");
        }
        if (channels != null) {
            for (String item : channels) {
                this.addToChannels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasChannels() {
        return this.channels != null && !this.channels.isEmpty();
    }

    @Override
    public String getImage() {
        return this.image;
    }

    @Override
    public A withImage(String image) {
        this.image = image;
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public A withUrl(String url) {
        this.url = url;
        return (A)this;
    }

    @Override
    public Boolean hasUrl() {
        return this.url != null;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public A withVersion(String version) {
        this.version = version;
        return (A)this;
    }

    @Override
    public Boolean hasVersion() {
        return this.version != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ReleaseFluentImpl that = (ReleaseFluentImpl)o;
        if (!Objects.equals(this.channels, that.channels)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.url, that.url)) {
            return false;
        }
        if (!Objects.equals(this.version, that.version)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.channels, this.image, this.url, this.version, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.channels != null && !this.channels.isEmpty()) {
            sb.append("channels:");
            sb.append(this.channels + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.url != null) {
            sb.append("url:");
            sb.append(this.url + ",");
        }
        if (this.version != null) {
            sb.append("version:");
            sb.append(this.version + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

