/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v6_7.Image;
import io.fabric8.openshift.api.model.v6_7.ImageBuilder;
import io.fabric8.openshift.api.model.v6_7.ImageFluentImpl;
import io.fabric8.openshift.api.model.v6_7.ImageTag;
import io.fabric8.openshift.api.model.v6_7.ImageTagFluent;
import io.fabric8.openshift.api.model.v6_7.NamedTagEventList;
import io.fabric8.openshift.api.model.v6_7.NamedTagEventListBuilder;
import io.fabric8.openshift.api.model.v6_7.NamedTagEventListFluentImpl;
import io.fabric8.openshift.api.model.v6_7.TagReference;
import io.fabric8.openshift.api.model.v6_7.TagReferenceBuilder;
import io.fabric8.openshift.api.model.v6_7.TagReferenceFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class ImageTagFluentImpl<A extends ImageTagFluent<A>>
extends BaseFluent<A>
implements ImageTagFluent<A> {
    private String apiVersion;
    private ImageBuilder image;
    private String kind;
    private ObjectMetaBuilder metadata;
    private TagReferenceBuilder spec;
    private NamedTagEventListBuilder status;
    private Map<String, Object> additionalProperties;

    public ImageTagFluentImpl() {
    }

    public ImageTagFluentImpl(ImageTag instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withImage(instance.getImage());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public Image getImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public Image buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    @Override
    public A withImage(Image image) {
        this._visitables.get("image").remove(this.image);
        if (image != null) {
            this.image = new ImageBuilder(image);
            this._visitables.get("image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get("image").remove(this.image);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImage() {
        return this.image != null;
    }

    @Override
    public ImageTagFluent.ImageNested<A> withNewImage() {
        return new ImageNestedImpl();
    }

    @Override
    public ImageTagFluent.ImageNested<A> withNewImageLike(Image item) {
        return new ImageNestedImpl(item);
    }

    @Override
    public ImageTagFluent.ImageNested<A> editImage() {
        return this.withNewImageLike(this.getImage());
    }

    @Override
    public ImageTagFluent.ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : new ImageBuilder().build());
    }

    @Override
    public ImageTagFluent.ImageNested<A> editOrNewImageLike(Image item) {
        return this.withNewImageLike(this.getImage() != null ? this.getImage() : item);
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ImageTagFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageTagFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageTagFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageTagFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageTagFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public TagReference getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public TagReference buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(TagReference spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new TagReferenceBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get("spec").remove(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ImageTagFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ImageTagFluent.SpecNested<A> withNewSpecLike(TagReference item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ImageTagFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ImageTagFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new TagReferenceBuilder().build());
    }

    @Override
    public ImageTagFluent.SpecNested<A> editOrNewSpecLike(TagReference item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public NamedTagEventList getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public NamedTagEventList buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(NamedTagEventList status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new NamedTagEventListBuilder(status);
            this._visitables.get("status").add(this.status);
        } else {
            this.status = null;
            this._visitables.get("status").remove(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ImageTagFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ImageTagFluent.StatusNested<A> withNewStatusLike(NamedTagEventList item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ImageTagFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ImageTagFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new NamedTagEventListBuilder().build());
    }

    @Override
    public ImageTagFluent.StatusNested<A> editOrNewStatusLike(NamedTagEventList item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageTagFluentImpl that = (ImageTagFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.spec, that.spec)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.image, this.kind, this.metadata, this.spec, this.status, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class StatusNestedImpl<N>
    extends NamedTagEventListFluentImpl<ImageTagFluent.StatusNested<N>>
    implements ImageTagFluent.StatusNested<N>,
    Nested<N> {
        NamedTagEventListBuilder builder;

        StatusNestedImpl(NamedTagEventList item) {
            this.builder = new NamedTagEventListBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new NamedTagEventListBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageTagFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    class SpecNestedImpl<N>
    extends TagReferenceFluentImpl<ImageTagFluent.SpecNested<N>>
    implements ImageTagFluent.SpecNested<N>,
    Nested<N> {
        TagReferenceBuilder builder;

        SpecNestedImpl(TagReference item) {
            this.builder = new TagReferenceBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new TagReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageTagFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageTagFluent.MetadataNested<N>>
    implements ImageTagFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageTagFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    class ImageNestedImpl<N>
    extends ImageFluentImpl<ImageTagFluent.ImageNested<N>>
    implements ImageTagFluent.ImageNested<N>,
    Nested<N> {
        ImageBuilder builder;

        ImageNestedImpl(Image item) {
            this.builder = new ImageBuilder(this, item);
        }

        ImageNestedImpl() {
            this.builder = new ImageBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageTagFluentImpl.this.withImage(this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

