/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.openshift.api.model.v6_7.ImageImportStatus;
import io.fabric8.openshift.api.model.v6_7.ImageImportStatusBuilder;
import io.fabric8.openshift.api.model.v6_7.ImageImportStatusFluentImpl;
import io.fabric8.openshift.api.model.v6_7.ImageStream;
import io.fabric8.openshift.api.model.v6_7.ImageStreamBuilder;
import io.fabric8.openshift.api.model.v6_7.ImageStreamFluentImpl;
import io.fabric8.openshift.api.model.v6_7.ImageStreamImportStatus;
import io.fabric8.openshift.api.model.v6_7.ImageStreamImportStatusFluent;
import io.fabric8.openshift.api.model.v6_7.RepositoryImportStatus;
import io.fabric8.openshift.api.model.v6_7.RepositoryImportStatusBuilder;
import io.fabric8.openshift.api.model.v6_7.RepositoryImportStatusFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImageStreamImportStatusFluentImpl<A extends ImageStreamImportStatusFluent<A>>
extends BaseFluent<A>
implements ImageStreamImportStatusFluent<A> {
    private ArrayList<ImageImportStatusBuilder> images = new ArrayList();
    private ImageStreamBuilder _import;
    private RepositoryImportStatusBuilder repository;
    private Map<String, Object> additionalProperties;

    public ImageStreamImportStatusFluentImpl() {
    }

    public ImageStreamImportStatusFluentImpl(ImageStreamImportStatus instance) {
        if (instance != null) {
            this.withImages(instance.getImages());
            this.withImport(instance.getImport());
            this.withRepository(instance.getRepository());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToImages(int index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get("images").add(index, builder);
            this.images.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToImages(int index, ImageImportStatus item) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
        if (index < 0 || index >= this.images.size()) {
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        } else {
            this._visitables.get("images").set(index, builder);
            this.images.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImages(ImageImportStatus ... items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImages(Collection<ImageImportStatus> items) {
        if (this.images == null) {
            this.images = new ArrayList();
        }
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").add(builder);
            this.images.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImages(ImageImportStatus ... items) {
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImages(Collection<ImageImportStatus> items) {
        for (ImageImportStatus item : items) {
            ImageImportStatusBuilder builder = new ImageImportStatusBuilder(item);
            this._visitables.get("images").remove(builder);
            if (this.images == null) continue;
            this.images.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImages(Predicate<ImageImportStatusBuilder> predicate) {
        if (this.images == null) {
            return (A)this;
        }
        Iterator<ImageImportStatusBuilder> each = this.images.iterator();
        Object visitables = this._visitables.get("images");
        while (each.hasNext()) {
            ImageImportStatusBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageImportStatus> getImages() {
        return this.images != null ? ImageStreamImportStatusFluentImpl.build(this.images) : null;
    }

    @Override
    public List<ImageImportStatus> buildImages() {
        return this.images != null ? ImageStreamImportStatusFluentImpl.build(this.images) : null;
    }

    @Override
    public ImageImportStatus buildImage(int index) {
        return this.images.get(index).build();
    }

    @Override
    public ImageImportStatus buildFirstImage() {
        return this.images.get(0).build();
    }

    @Override
    public ImageImportStatus buildLastImage() {
        return this.images.get(this.images.size() - 1).build();
    }

    @Override
    public ImageImportStatus buildMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        for (ImageImportStatusBuilder item : this.images) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImages(List<ImageImportStatus> images) {
        if (this.images != null) {
            this._visitables.get("images").clear();
        }
        if (images != null) {
            this.images = new ArrayList();
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        } else {
            this.images = null;
        }
        return (A)this;
    }

    @Override
    public A withImages(ImageImportStatus ... images) {
        if (this.images != null) {
            this.images.clear();
            this._visitables.remove("images");
        }
        if (images != null) {
            for (ImageImportStatus item : images) {
                this.addToImages(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImages() {
        return this.images != null && !this.images.isEmpty();
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> addNewImage() {
        return new ImagesNestedImpl();
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> addNewImageLike(ImageImportStatus item) {
        return new ImagesNestedImpl(-1, item);
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> setNewImageLike(int index, ImageImportStatus item) {
        return new ImagesNestedImpl(index, item);
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editImage(int index) {
        if (this.images.size() <= index) {
            throw new RuntimeException("Can't edit images. Index exceeds size.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editFirstImage() {
        if (this.images.size() == 0) {
            throw new RuntimeException("Can't edit first images. The list is empty.");
        }
        return this.setNewImageLike(0, this.buildImage(0));
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editLastImage() {
        int index = this.images.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last images. The list is empty.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    public ImageStreamImportStatusFluent.ImagesNested<A> editMatchingImage(Predicate<ImageImportStatusBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.images.size(); ++i) {
            if (!predicate.test(this.images.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching images. No match found.");
        }
        return this.setNewImageLike(index, this.buildImage(index));
    }

    @Override
    @Deprecated
    public ImageStream getImport() {
        return this._import != null ? this._import.build() : null;
    }

    @Override
    public ImageStream buildImport() {
        return this._import != null ? this._import.build() : null;
    }

    @Override
    public A withImport(ImageStream _import) {
        this._visitables.get("_import").remove(this._import);
        if (_import != null) {
            this._import = new ImageStreamBuilder(_import);
            this._visitables.get("_import").add(this._import);
        } else {
            this._import = null;
            this._visitables.get("_import").remove(this._import);
        }
        return (A)this;
    }

    @Override
    public Boolean hasImport() {
        return this._import != null;
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> withNewImport() {
        return new ImportNestedImpl();
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> withNewImportLike(ImageStream item) {
        return new ImportNestedImpl(item);
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> editImport() {
        return this.withNewImportLike(this.getImport());
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> editOrNewImport() {
        return this.withNewImportLike(this.getImport() != null ? this.getImport() : new ImageStreamBuilder().build());
    }

    @Override
    public ImageStreamImportStatusFluent.ImportNested<A> editOrNewImportLike(ImageStream item) {
        return this.withNewImportLike(this.getImport() != null ? this.getImport() : item);
    }

    @Override
    @Deprecated
    public RepositoryImportStatus getRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public RepositoryImportStatus buildRepository() {
        return this.repository != null ? this.repository.build() : null;
    }

    @Override
    public A withRepository(RepositoryImportStatus repository) {
        this._visitables.get("repository").remove(this.repository);
        if (repository != null) {
            this.repository = new RepositoryImportStatusBuilder(repository);
            this._visitables.get("repository").add(this.repository);
        } else {
            this.repository = null;
            this._visitables.get("repository").remove(this.repository);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRepository() {
        return this.repository != null;
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepository() {
        return new RepositoryNestedImpl();
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> withNewRepositoryLike(RepositoryImportStatus item) {
        return new RepositoryNestedImpl(item);
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> editRepository() {
        return this.withNewRepositoryLike(this.getRepository());
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepository() {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : new RepositoryImportStatusBuilder().build());
    }

    @Override
    public ImageStreamImportStatusFluent.RepositoryNested<A> editOrNewRepositoryLike(RepositoryImportStatus item) {
        return this.withNewRepositoryLike(this.getRepository() != null ? this.getRepository() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ImageStreamImportStatusFluentImpl that = (ImageStreamImportStatusFluentImpl)o;
        if (!Objects.equals(this.images, that.images)) {
            return false;
        }
        if (!Objects.equals(this._import, that._import)) {
            return false;
        }
        if (!Objects.equals(this.repository, that.repository)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.images, this._import, this.repository, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.images != null && !this.images.isEmpty()) {
            sb.append("images:");
            sb.append(this.images + ",");
        }
        if (this._import != null) {
            sb.append("_import:");
            sb.append(this._import + ",");
        }
        if (this.repository != null) {
            sb.append("repository:");
            sb.append(this.repository + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class RepositoryNestedImpl<N>
    extends RepositoryImportStatusFluentImpl<ImageStreamImportStatusFluent.RepositoryNested<N>>
    implements ImageStreamImportStatusFluent.RepositoryNested<N>,
    Nested<N> {
        RepositoryImportStatusBuilder builder;

        RepositoryNestedImpl(RepositoryImportStatus item) {
            this.builder = new RepositoryImportStatusBuilder(this, item);
        }

        RepositoryNestedImpl() {
            this.builder = new RepositoryImportStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportStatusFluentImpl.this.withRepository(this.builder.build());
        }

        @Override
        public N endRepository() {
            return this.and();
        }
    }

    class ImportNestedImpl<N>
    extends ImageStreamFluentImpl<ImageStreamImportStatusFluent.ImportNested<N>>
    implements ImageStreamImportStatusFluent.ImportNested<N>,
    Nested<N> {
        ImageStreamBuilder builder;

        ImportNestedImpl(ImageStream item) {
            this.builder = new ImageStreamBuilder(this, item);
        }

        ImportNestedImpl() {
            this.builder = new ImageStreamBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportStatusFluentImpl.this.withImport(this.builder.build());
        }

        @Override
        public N endImport() {
            return this.and();
        }
    }

    class ImagesNestedImpl<N>
    extends ImageImportStatusFluentImpl<ImageStreamImportStatusFluent.ImagesNested<N>>
    implements ImageStreamImportStatusFluent.ImagesNested<N>,
    Nested<N> {
        ImageImportStatusBuilder builder;
        int index;

        ImagesNestedImpl(int index, ImageImportStatus item) {
            this.index = index;
            this.builder = new ImageImportStatusBuilder(this, item);
        }

        ImagesNestedImpl() {
            this.index = -1;
            this.builder = new ImageImportStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamImportStatusFluentImpl.this.setToImages(this.index, this.builder.build());
        }

        @Override
        public N endImage() {
            return this.and();
        }
    }
}

