/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.openshift.api.model.v6_7.ClusterRoleScopeRestriction;
import io.fabric8.openshift.api.model.v6_7.ClusterRoleScopeRestrictionFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterRoleScopeRestrictionFluentImpl<A extends ClusterRoleScopeRestrictionFluent<A>>
extends BaseFluent<A>
implements ClusterRoleScopeRestrictionFluent<A> {
    private Boolean allowEscalation;
    private List<String> namespaces = new ArrayList<String>();
    private List<String> roleNames = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ClusterRoleScopeRestrictionFluentImpl() {
    }

    public ClusterRoleScopeRestrictionFluentImpl(ClusterRoleScopeRestriction instance) {
        if (instance != null) {
            this.withAllowEscalation(instance.getAllowEscalation());
            this.withNamespaces(instance.getNamespaces());
            this.withRoleNames(instance.getRoleNames());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public Boolean getAllowEscalation() {
        return this.allowEscalation;
    }

    @Override
    public A withAllowEscalation(Boolean allowEscalation) {
        this.allowEscalation = allowEscalation;
        return (A)this;
    }

    @Override
    public Boolean hasAllowEscalation() {
        return this.allowEscalation != null;
    }

    @Override
    public A addToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNamespaces(int index, String item) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        this.namespaces.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNamespaces(String ... items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNamespaces(Collection<String> items) {
        if (this.namespaces == null) {
            this.namespaces = new ArrayList<String>();
        }
        for (String item : items) {
            this.namespaces.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNamespaces(String ... items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNamespaces(Collection<String> items) {
        for (String item : items) {
            if (this.namespaces == null) continue;
            this.namespaces.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespace(int index) {
        return this.namespaces.get(index);
    }

    @Override
    public String getFirstNamespace() {
        return this.namespaces.get(0);
    }

    @Override
    public String getLastNamespace() {
        return this.namespaces.get(this.namespaces.size() - 1);
    }

    @Override
    public String getMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNamespace(Predicate<String> predicate) {
        for (String item : this.namespaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNamespaces(List<String> namespaces) {
        if (namespaces != null) {
            this.namespaces = new ArrayList<String>();
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        } else {
            this.namespaces = null;
        }
        return (A)this;
    }

    @Override
    public A withNamespaces(String ... namespaces) {
        if (this.namespaces != null) {
            this.namespaces.clear();
            this._visitables.remove("namespaces");
        }
        if (namespaces != null) {
            for (String item : namespaces) {
                this.addToNamespaces(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaces() {
        return this.namespaces != null && !this.namespaces.isEmpty();
    }

    @Override
    public A addToRoleNames(int index, String item) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        this.roleNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToRoleNames(int index, String item) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        this.roleNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToRoleNames(String ... items) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToRoleNames(Collection<String> items) {
        if (this.roleNames == null) {
            this.roleNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.roleNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromRoleNames(String ... items) {
        for (String item : items) {
            if (this.roleNames == null) continue;
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRoleNames(Collection<String> items) {
        for (String item : items) {
            if (this.roleNames == null) continue;
            this.roleNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getRoleNames() {
        return this.roleNames;
    }

    @Override
    public String getRoleName(int index) {
        return this.roleNames.get(index);
    }

    @Override
    public String getFirstRoleName() {
        return this.roleNames.get(0);
    }

    @Override
    public String getLastRoleName() {
        return this.roleNames.get(this.roleNames.size() - 1);
    }

    @Override
    public String getMatchingRoleName(Predicate<String> predicate) {
        for (String item : this.roleNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRoleName(Predicate<String> predicate) {
        for (String item : this.roleNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRoleNames(List<String> roleNames) {
        if (roleNames != null) {
            this.roleNames = new ArrayList<String>();
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        } else {
            this.roleNames = null;
        }
        return (A)this;
    }

    @Override
    public A withRoleNames(String ... roleNames) {
        if (this.roleNames != null) {
            this.roleNames.clear();
            this._visitables.remove("roleNames");
        }
        if (roleNames != null) {
            for (String item : roleNames) {
                this.addToRoleNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleNames() {
        return this.roleNames != null && !this.roleNames.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleScopeRestrictionFluentImpl that = (ClusterRoleScopeRestrictionFluentImpl)o;
        if (!Objects.equals(this.allowEscalation, that.allowEscalation)) {
            return false;
        }
        if (!Objects.equals(this.namespaces, that.namespaces)) {
            return false;
        }
        if (!Objects.equals(this.roleNames, that.roleNames)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowEscalation, this.namespaces, this.roleNames, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowEscalation != null) {
            sb.append("allowEscalation:");
            sb.append(this.allowEscalation + ",");
        }
        if (this.namespaces != null && !this.namespaces.isEmpty()) {
            sb.append("namespaces:");
            sb.append(this.namespaces + ",");
        }
        if (this.roleNames != null && !this.roleNames.isEmpty()) {
            sb.append("roleNames:");
            sb.append(this.roleNames + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAllowEscalation() {
        return this.withAllowEscalation(true);
    }
}

