/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReference;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.LocalObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.ObjectReference;
import io.fabric8.kubernetes.api.model.v6_7.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v6_7.BuildOutput;
import io.fabric8.openshift.api.model.v6_7.BuildOutputFluent;
import io.fabric8.openshift.api.model.v6_7.ImageLabel;
import io.fabric8.openshift.api.model.v6_7.ImageLabelBuilder;
import io.fabric8.openshift.api.model.v6_7.ImageLabelFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class BuildOutputFluentImpl<A extends BuildOutputFluent<A>>
extends BaseFluent<A>
implements BuildOutputFluent<A> {
    private ArrayList<ImageLabelBuilder> imageLabels = new ArrayList();
    private LocalObjectReferenceBuilder pushSecret;
    private ObjectReferenceBuilder to;
    private Map<String, Object> additionalProperties;

    public BuildOutputFluentImpl() {
    }

    public BuildOutputFluentImpl(BuildOutput instance) {
        if (instance != null) {
            this.withImageLabels(instance.getImageLabels());
            this.withPushSecret(instance.getPushSecret());
            this.withTo(instance.getTo());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").add(index, builder);
            this.imageLabels.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToImageLabels(int index, ImageLabel item) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        ImageLabelBuilder builder = new ImageLabelBuilder(item);
        if (index < 0 || index >= this.imageLabels.size()) {
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        } else {
            this._visitables.get("imageLabels").set(index, builder);
            this.imageLabels.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToImageLabels(ImageLabel ... items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToImageLabels(Collection<ImageLabel> items) {
        if (this.imageLabels == null) {
            this.imageLabels = new ArrayList();
        }
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").add(builder);
            this.imageLabels.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromImageLabels(ImageLabel ... items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            if (this.imageLabels == null) continue;
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromImageLabels(Collection<ImageLabel> items) {
        for (ImageLabel item : items) {
            ImageLabelBuilder builder = new ImageLabelBuilder(item);
            this._visitables.get("imageLabels").remove(builder);
            if (this.imageLabels == null) continue;
            this.imageLabels.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromImageLabels(Predicate<ImageLabelBuilder> predicate) {
        if (this.imageLabels == null) {
            return (A)this;
        }
        Iterator<ImageLabelBuilder> each = this.imageLabels.iterator();
        Object visitables = this._visitables.get("imageLabels");
        while (each.hasNext()) {
            ImageLabelBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ImageLabel> getImageLabels() {
        return this.imageLabels != null ? BuildOutputFluentImpl.build(this.imageLabels) : null;
    }

    @Override
    public List<ImageLabel> buildImageLabels() {
        return this.imageLabels != null ? BuildOutputFluentImpl.build(this.imageLabels) : null;
    }

    @Override
    public ImageLabel buildImageLabel(int index) {
        return this.imageLabels.get(index).build();
    }

    @Override
    public ImageLabel buildFirstImageLabel() {
        return this.imageLabels.get(0).build();
    }

    @Override
    public ImageLabel buildLastImageLabel() {
        return this.imageLabels.get(this.imageLabels.size() - 1).build();
    }

    @Override
    public ImageLabel buildMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        for (ImageLabelBuilder item : this.imageLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withImageLabels(List<ImageLabel> imageLabels) {
        if (this.imageLabels != null) {
            this._visitables.get("imageLabels").clear();
        }
        if (imageLabels != null) {
            this.imageLabels = new ArrayList();
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        } else {
            this.imageLabels = null;
        }
        return (A)this;
    }

    @Override
    public A withImageLabels(ImageLabel ... imageLabels) {
        if (this.imageLabels != null) {
            this.imageLabels.clear();
            this._visitables.remove("imageLabels");
        }
        if (imageLabels != null) {
            for (ImageLabel item : imageLabels) {
                this.addToImageLabels(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasImageLabels() {
        return this.imageLabels != null && !this.imageLabels.isEmpty();
    }

    @Override
    public A addNewImageLabel(String name, String value) {
        return this.addToImageLabels(new ImageLabel(name, value));
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> addNewImageLabel() {
        return new ImageLabelsNestedImpl();
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> addNewImageLabelLike(ImageLabel item) {
        return new ImageLabelsNestedImpl(-1, item);
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> setNewImageLabelLike(int index, ImageLabel item) {
        return new ImageLabelsNestedImpl(index, item);
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editImageLabel(int index) {
        if (this.imageLabels.size() <= index) {
            throw new RuntimeException("Can't edit imageLabels. Index exceeds size.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editFirstImageLabel() {
        if (this.imageLabels.size() == 0) {
            throw new RuntimeException("Can't edit first imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(0, this.buildImageLabel(0));
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editLastImageLabel() {
        int index = this.imageLabels.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last imageLabels. The list is empty.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    public BuildOutputFluent.ImageLabelsNested<A> editMatchingImageLabel(Predicate<ImageLabelBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.imageLabels.size(); ++i) {
            if (!predicate.test(this.imageLabels.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching imageLabels. No match found.");
        }
        return this.setNewImageLabelLike(index, this.buildImageLabel(index));
    }

    @Override
    @Deprecated
    public LocalObjectReference getPushSecret() {
        return this.pushSecret != null ? this.pushSecret.build() : null;
    }

    @Override
    public LocalObjectReference buildPushSecret() {
        return this.pushSecret != null ? this.pushSecret.build() : null;
    }

    @Override
    public A withPushSecret(LocalObjectReference pushSecret) {
        this._visitables.get("pushSecret").remove(this.pushSecret);
        if (pushSecret != null) {
            this.pushSecret = new LocalObjectReferenceBuilder(pushSecret);
            this._visitables.get("pushSecret").add(this.pushSecret);
        } else {
            this.pushSecret = null;
            this._visitables.get("pushSecret").remove(this.pushSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPushSecret() {
        return this.pushSecret != null;
    }

    @Override
    public A withNewPushSecret(String name) {
        return this.withPushSecret(new LocalObjectReference(name));
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecret() {
        return new PushSecretNestedImpl();
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> withNewPushSecretLike(LocalObjectReference item) {
        return new PushSecretNestedImpl(item);
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editPushSecret() {
        return this.withNewPushSecretLike(this.getPushSecret());
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecret() {
        return this.withNewPushSecretLike(this.getPushSecret() != null ? this.getPushSecret() : new LocalObjectReferenceBuilder().build());
    }

    @Override
    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecretLike(LocalObjectReference item) {
        return this.withNewPushSecretLike(this.getPushSecret() != null ? this.getPushSecret() : item);
    }

    @Override
    @Deprecated
    public ObjectReference getTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public ObjectReference buildTo() {
        return this.to != null ? this.to.build() : null;
    }

    @Override
    public A withTo(ObjectReference to) {
        this._visitables.get("to").remove(this.to);
        if (to != null) {
            this.to = new ObjectReferenceBuilder(to);
            this._visitables.get("to").add(this.to);
        } else {
            this.to = null;
            this._visitables.get("to").remove(this.to);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTo() {
        return this.to != null;
    }

    @Override
    public BuildOutputFluent.ToNested<A> withNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public BuildOutputFluent.ToNested<A> withNewToLike(ObjectReference item) {
        return new ToNestedImpl(item);
    }

    @Override
    public BuildOutputFluent.ToNested<A> editTo() {
        return this.withNewToLike(this.getTo());
    }

    @Override
    public BuildOutputFluent.ToNested<A> editOrNewTo() {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : new ObjectReferenceBuilder().build());
    }

    @Override
    public BuildOutputFluent.ToNested<A> editOrNewToLike(ObjectReference item) {
        return this.withNewToLike(this.getTo() != null ? this.getTo() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildOutputFluentImpl that = (BuildOutputFluentImpl)o;
        if (!Objects.equals(this.imageLabels, that.imageLabels)) {
            return false;
        }
        if (!Objects.equals(this.pushSecret, that.pushSecret)) {
            return false;
        }
        if (!Objects.equals(this.to, that.to)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.imageLabels, this.pushSecret, this.to, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageLabels != null && !this.imageLabels.isEmpty()) {
            sb.append("imageLabels:");
            sb.append(this.imageLabels + ",");
        }
        if (this.pushSecret != null) {
            sb.append("pushSecret:");
            sb.append(this.pushSecret + ",");
        }
        if (this.to != null) {
            sb.append("to:");
            sb.append(this.to + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ToNestedImpl<N>
    extends ObjectReferenceFluentImpl<BuildOutputFluent.ToNested<N>>
    implements BuildOutputFluent.ToNested<N>,
    Nested<N> {
        ObjectReferenceBuilder builder;

        ToNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        ToNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.withTo(this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    class PushSecretNestedImpl<N>
    extends LocalObjectReferenceFluentImpl<BuildOutputFluent.PushSecretNested<N>>
    implements BuildOutputFluent.PushSecretNested<N>,
    Nested<N> {
        LocalObjectReferenceBuilder builder;

        PushSecretNestedImpl(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        PushSecretNestedImpl() {
            this.builder = new LocalObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.withPushSecret(this.builder.build());
        }

        @Override
        public N endPushSecret() {
            return this.and();
        }
    }

    class ImageLabelsNestedImpl<N>
    extends ImageLabelFluentImpl<BuildOutputFluent.ImageLabelsNested<N>>
    implements BuildOutputFluent.ImageLabelsNested<N>,
    Nested<N> {
        ImageLabelBuilder builder;
        int index;

        ImageLabelsNestedImpl(int index, ImageLabel item) {
            this.index = index;
            this.builder = new ImageLabelBuilder(this, item);
        }

        ImageLabelsNestedImpl() {
            this.index = -1;
            this.builder = new ImageLabelBuilder(this);
        }

        @Override
        public N and() {
            return (N)BuildOutputFluentImpl.this.setToImageLabels(this.index, this.builder.build());
        }

        @Override
        public N endImageLabel() {
            return this.and();
        }
    }
}

