/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.policy.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_7.policy.v1beta1.RuntimeClassStrategyOptions;
import io.fabric8.kubernetes.api.model.v6_7.policy.v1beta1.RuntimeClassStrategyOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RuntimeClassStrategyOptionsFluentImpl<A extends RuntimeClassStrategyOptionsFluent<A>>
extends BaseFluent<A>
implements RuntimeClassStrategyOptionsFluent<A> {
    private List<String> allowedRuntimeClassNames = new ArrayList<String>();
    private String defaultRuntimeClassName;
    private Map<String, Object> additionalProperties;

    public RuntimeClassStrategyOptionsFluentImpl() {
    }

    public RuntimeClassStrategyOptionsFluentImpl(RuntimeClassStrategyOptions instance) {
        if (instance != null) {
            this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames());
            this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAllowedRuntimeClassNames(int index, String item) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        this.allowedRuntimeClassNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAllowedRuntimeClassNames(int index, String item) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        this.allowedRuntimeClassNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAllowedRuntimeClassNames(String ... items) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAllowedRuntimeClassNames(Collection<String> items) {
        if (this.allowedRuntimeClassNames == null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.allowedRuntimeClassNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAllowedRuntimeClassNames(String ... items) {
        for (String item : items) {
            if (this.allowedRuntimeClassNames == null) continue;
            this.allowedRuntimeClassNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAllowedRuntimeClassNames(Collection<String> items) {
        for (String item : items) {
            if (this.allowedRuntimeClassNames == null) continue;
            this.allowedRuntimeClassNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAllowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames;
    }

    @Override
    public String getAllowedRuntimeClassName(int index) {
        return this.allowedRuntimeClassNames.get(index);
    }

    @Override
    public String getFirstAllowedRuntimeClassName() {
        return this.allowedRuntimeClassNames.get(0);
    }

    @Override
    public String getLastAllowedRuntimeClassName() {
        return this.allowedRuntimeClassNames.get(this.allowedRuntimeClassNames.size() - 1);
    }

    @Override
    public String getMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
        for (String item : this.allowedRuntimeClassNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAllowedRuntimeClassName(Predicate<String> predicate) {
        for (String item : this.allowedRuntimeClassNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAllowedRuntimeClassNames(List<String> allowedRuntimeClassNames) {
        if (allowedRuntimeClassNames != null) {
            this.allowedRuntimeClassNames = new ArrayList<String>();
            for (String item : allowedRuntimeClassNames) {
                this.addToAllowedRuntimeClassNames(item);
            }
        } else {
            this.allowedRuntimeClassNames = null;
        }
        return (A)this;
    }

    @Override
    public A withAllowedRuntimeClassNames(String ... allowedRuntimeClassNames) {
        if (this.allowedRuntimeClassNames != null) {
            this.allowedRuntimeClassNames.clear();
            this._visitables.remove("allowedRuntimeClassNames");
        }
        if (allowedRuntimeClassNames != null) {
            for (String item : allowedRuntimeClassNames) {
                this.addToAllowedRuntimeClassNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAllowedRuntimeClassNames() {
        return this.allowedRuntimeClassNames != null && !this.allowedRuntimeClassNames.isEmpty();
    }

    @Override
    public String getDefaultRuntimeClassName() {
        return this.defaultRuntimeClassName;
    }

    @Override
    public A withDefaultRuntimeClassName(String defaultRuntimeClassName) {
        this.defaultRuntimeClassName = defaultRuntimeClassName;
        return (A)this;
    }

    @Override
    public Boolean hasDefaultRuntimeClassName() {
        return this.defaultRuntimeClassName != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RuntimeClassStrategyOptionsFluentImpl that = (RuntimeClassStrategyOptionsFluentImpl)o;
        if (!Objects.equals(this.allowedRuntimeClassNames, that.allowedRuntimeClassNames)) {
            return false;
        }
        if (!Objects.equals(this.defaultRuntimeClassName, that.defaultRuntimeClassName)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.allowedRuntimeClassNames, this.defaultRuntimeClassName, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.allowedRuntimeClassNames != null && !this.allowedRuntimeClassNames.isEmpty()) {
            sb.append("allowedRuntimeClassNames:");
            sb.append(this.allowedRuntimeClassNames + ",");
        }
        if (this.defaultRuntimeClassName != null) {
            sb.append("defaultRuntimeClassName:");
            sb.append(this.defaultRuntimeClassName + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

