/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.extensions;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.LabelSelector;
import io.fabric8.kubernetes.api.model.v6_7.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v6_7.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.extensions.IPBlock;
import io.fabric8.kubernetes.api.model.v6_7.extensions.IPBlockBuilder;
import io.fabric8.kubernetes.api.model.v6_7.extensions.IPBlockFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPeerFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class NetworkPolicyPeerFluentImpl<A extends NetworkPolicyPeerFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyPeerFluent<A> {
    private IPBlockBuilder ipBlock;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder podSelector;
    private Map<String, Object> additionalProperties;

    public NetworkPolicyPeerFluentImpl() {
    }

    public NetworkPolicyPeerFluentImpl(NetworkPolicyPeer instance) {
        if (instance != null) {
            this.withIpBlock(instance.getIpBlock());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withPodSelector(instance.getPodSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    @Deprecated
    public IPBlock getIpBlock() {
        return this.ipBlock != null ? this.ipBlock.build() : null;
    }

    @Override
    public IPBlock buildIpBlock() {
        return this.ipBlock != null ? this.ipBlock.build() : null;
    }

    @Override
    public A withIpBlock(IPBlock ipBlock) {
        this._visitables.get("ipBlock").remove(this.ipBlock);
        if (ipBlock != null) {
            this.ipBlock = new IPBlockBuilder(ipBlock);
            this._visitables.get("ipBlock").add(this.ipBlock);
        } else {
            this.ipBlock = null;
            this._visitables.get("ipBlock").remove(this.ipBlock);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpBlock() {
        return this.ipBlock != null;
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlock() {
        return new IpBlockNestedImpl();
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlockLike(IPBlock item) {
        return new IpBlockNestedImpl(item);
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> editIpBlock() {
        return this.withNewIpBlockLike(this.getIpBlock());
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlock() {
        return this.withNewIpBlockLike(this.getIpBlock() != null ? this.getIpBlock() : new IPBlockBuilder().build());
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlockLike(IPBlock item) {
        return this.withNewIpBlockLike(this.getIpBlock() != null ? this.getIpBlock() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.get("podSelector").remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get("podSelector").add(this.podSelector);
        } else {
            this.podSelector = null;
            this._visitables.get("podSelector").remove(this.podSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodSelector() {
        return this.podSelector != null;
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNestedImpl();
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNestedImpl(item);
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector());
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyPeerFluentImpl that = (NetworkPolicyPeerFluentImpl)o;
        if (!Objects.equals(this.ipBlock, that.ipBlock)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.podSelector, that.podSelector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ipBlock, this.namespaceSelector, this.podSelector, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ipBlock != null) {
            sb.append("ipBlock:");
            sb.append(this.ipBlock + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.podSelector != null) {
            sb.append("podSelector:");
            sb.append(this.podSelector + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PodSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.PodSelectorNested<N>>
    implements NetworkPolicyPeerFluent.PodSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        PodSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        PodSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluentImpl.this.withPodSelector(this.builder.build());
        }

        @Override
        public N endPodSelector() {
            return this.and();
        }
    }

    class NamespaceSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.NamespaceSelectorNested<N>>
    implements NetworkPolicyPeerFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    class IpBlockNestedImpl<N>
    extends IPBlockFluentImpl<NetworkPolicyPeerFluent.IpBlockNested<N>>
    implements NetworkPolicyPeerFluent.IpBlockNested<N>,
    Nested<N> {
        IPBlockBuilder builder;

        IpBlockNestedImpl(IPBlock item) {
            this.builder = new IPBlockBuilder(this, item);
        }

        IpBlockNestedImpl() {
            this.builder = new IPBlockBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluentImpl.this.withIpBlock(this.builder.build());
        }

        @Override
        public N endIpBlock() {
            return this.and();
        }
    }
}

