/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.extensions;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyEgressRule;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyEgressRuleFluent;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPeerBuilder;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPeerFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPort;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPortBuilder;
import io.fabric8.kubernetes.api.model.v6_7.extensions.NetworkPolicyPortFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NetworkPolicyEgressRuleFluentImpl<A extends NetworkPolicyEgressRuleFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyEgressRuleFluent<A> {
    private ArrayList<NetworkPolicyPortBuilder> ports = new ArrayList();
    private ArrayList<NetworkPolicyPeerBuilder> to = new ArrayList();
    private Map<String, Object> additionalProperties;

    public NetworkPolicyEgressRuleFluentImpl() {
    }

    public NetworkPolicyEgressRuleFluentImpl(NetworkPolicyEgressRule instance) {
        if (instance != null) {
            this.withPorts(instance.getPorts());
            this.withTo(instance.getTo());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").add(index, builder);
            this.ports.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToPorts(int index, NetworkPolicyPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
        if (index < 0 || index >= this.ports.size()) {
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(NetworkPolicyPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<NetworkPolicyPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList();
        }
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(NetworkPolicyPort ... items) {
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<NetworkPolicyPort> items) {
        for (NetworkPolicyPort item : items) {
            NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<NetworkPolicyPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            NetworkPolicyPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyPort> getPorts() {
        return this.ports != null ? NetworkPolicyEgressRuleFluentImpl.build(this.ports) : null;
    }

    @Override
    public List<NetworkPolicyPort> buildPorts() {
        return this.ports != null ? NetworkPolicyEgressRuleFluentImpl.build(this.ports) : null;
    }

    @Override
    public NetworkPolicyPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public NetworkPolicyPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public NetworkPolicyPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public NetworkPolicyPort buildMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        for (NetworkPolicyPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<NetworkPolicyPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").clear();
        }
        if (ports != null) {
            this.ports = new ArrayList();
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(NetworkPolicyPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
            this._visitables.remove("ports");
        }
        if (ports != null) {
            for (NetworkPolicyPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPortLike(NetworkPolicyPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> setNewPortLike(int index, NetworkPolicyPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.PortsNested<A> editMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public A addToTo(int index, NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.to.size()) {
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        } else {
            this._visitables.get("to").add(index, builder);
            this.to.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToTo(int index, NetworkPolicyPeer item) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
        if (index < 0 || index >= this.to.size()) {
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        } else {
            this._visitables.get("to").set(index, builder);
            this.to.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTo(NetworkPolicyPeer ... items) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTo(Collection<NetworkPolicyPeer> items) {
        if (this.to == null) {
            this.to = new ArrayList();
        }
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").add(builder);
            this.to.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTo(NetworkPolicyPeer ... items) {
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            if (this.to == null) continue;
            this.to.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTo(Collection<NetworkPolicyPeer> items) {
        for (NetworkPolicyPeer item : items) {
            NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
            this._visitables.get("to").remove(builder);
            if (this.to == null) continue;
            this.to.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        if (this.to == null) {
            return (A)this;
        }
        Iterator<NetworkPolicyPeerBuilder> each = this.to.iterator();
        Object visitables = this._visitables.get("to");
        while (each.hasNext()) {
            NetworkPolicyPeerBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NetworkPolicyPeer> getTo() {
        return this.to != null ? NetworkPolicyEgressRuleFluentImpl.build(this.to) : null;
    }

    @Override
    public List<NetworkPolicyPeer> buildTo() {
        return this.to != null ? NetworkPolicyEgressRuleFluentImpl.build(this.to) : null;
    }

    @Override
    public NetworkPolicyPeer buildTo(int index) {
        return this.to.get(index).build();
    }

    @Override
    public NetworkPolicyPeer buildFirstTo() {
        return this.to.get(0).build();
    }

    @Override
    public NetworkPolicyPeer buildLastTo() {
        return this.to.get(this.to.size() - 1).build();
    }

    @Override
    public NetworkPolicyPeer buildMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        for (NetworkPolicyPeerBuilder item : this.to) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTo(List<NetworkPolicyPeer> to) {
        if (this.to != null) {
            this._visitables.get("to").clear();
        }
        if (to != null) {
            this.to = new ArrayList();
            for (NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        } else {
            this.to = null;
        }
        return (A)this;
    }

    @Override
    public A withTo(NetworkPolicyPeer ... to) {
        if (this.to != null) {
            this.to.clear();
            this._visitables.remove("to");
        }
        if (to != null) {
            for (NetworkPolicyPeer item : to) {
                this.addToTo(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTo() {
        return this.to != null && !this.to.isEmpty();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> addNewTo() {
        return new ToNestedImpl();
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> addNewToLike(NetworkPolicyPeer item) {
        return new ToNestedImpl(-1, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> setNewToLike(int index, NetworkPolicyPeer item) {
        return new ToNestedImpl(index, item);
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editTo(int index) {
        if (this.to.size() <= index) {
            throw new RuntimeException("Can't edit to. Index exceeds size.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editFirstTo() {
        if (this.to.size() == 0) {
            throw new RuntimeException("Can't edit first to. The list is empty.");
        }
        return this.setNewToLike(0, this.buildTo(0));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editLastTo() {
        int index = this.to.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last to. The list is empty.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    @Override
    public NetworkPolicyEgressRuleFluent.ToNested<A> editMatchingTo(Predicate<NetworkPolicyPeerBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.to.size(); ++i) {
            if (!predicate.test(this.to.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching to. No match found.");
        }
        return this.setNewToLike(index, this.buildTo(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyEgressRuleFluentImpl that = (NetworkPolicyEgressRuleFluentImpl)o;
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals(this.to, that.to)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ports, this.to, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ports != null) {
            sb.append("ports:");
            sb.append(this.ports + ",");
        }
        if (this.to != null) {
            sb.append("to:");
            sb.append(this.to + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ToNestedImpl<N>
    extends NetworkPolicyPeerFluentImpl<NetworkPolicyEgressRuleFluent.ToNested<N>>
    implements NetworkPolicyEgressRuleFluent.ToNested<N>,
    Nested<N> {
        NetworkPolicyPeerBuilder builder;
        int index;

        ToNestedImpl(int index, NetworkPolicyPeer item) {
            this.index = index;
            this.builder = new NetworkPolicyPeerBuilder(this, item);
        }

        ToNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyPeerBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyEgressRuleFluentImpl.this.setToTo(this.index, this.builder.build());
        }

        @Override
        public N endTo() {
            return this.and();
        }
    }

    class PortsNestedImpl<N>
    extends NetworkPolicyPortFluentImpl<NetworkPolicyEgressRuleFluent.PortsNested<N>>
    implements NetworkPolicyEgressRuleFluent.PortsNested<N>,
    Nested<N> {
        NetworkPolicyPortBuilder builder;
        int index;

        PortsNestedImpl(int index, NetworkPolicyPort item) {
            this.index = index;
            this.builder = new NetworkPolicyPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new NetworkPolicyPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyEgressRuleFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }
}

