/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.batch.v1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.batch.v1.CronJobSpec;
import io.fabric8.kubernetes.api.model.v6_7.batch.v1.CronJobSpecFluent;
import io.fabric8.kubernetes.api.model.v6_7.batch.v1.JobTemplateSpec;
import io.fabric8.kubernetes.api.model.v6_7.batch.v1.JobTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.v6_7.batch.v1.JobTemplateSpecFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class CronJobSpecFluentImpl<A extends CronJobSpecFluent<A>>
extends BaseFluent<A>
implements CronJobSpecFluent<A> {
    private String concurrencyPolicy;
    private Integer failedJobsHistoryLimit;
    private JobTemplateSpecBuilder jobTemplate;
    private String schedule;
    private Long startingDeadlineSeconds;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;
    private String timeZone;
    private Map<String, Object> additionalProperties;

    public CronJobSpecFluentImpl() {
    }

    public CronJobSpecFluentImpl(CronJobSpec instance) {
        if (instance != null) {
            this.withConcurrencyPolicy(instance.getConcurrencyPolicy());
            this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
            this.withJobTemplate(instance.getJobTemplate());
            this.withSchedule(instance.getSchedule());
            this.withStartingDeadlineSeconds(instance.getStartingDeadlineSeconds());
            this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
            this.withSuspend(instance.getSuspend());
            this.withTimeZone(instance.getTimeZone());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getConcurrencyPolicy() {
        return this.concurrencyPolicy;
    }

    @Override
    public A withConcurrencyPolicy(String concurrencyPolicy) {
        this.concurrencyPolicy = concurrencyPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasConcurrencyPolicy() {
        return this.concurrencyPolicy != null;
    }

    @Override
    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    @Override
    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit != null;
    }

    @Override
    @Deprecated
    public JobTemplateSpec getJobTemplate() {
        return this.jobTemplate != null ? this.jobTemplate.build() : null;
    }

    @Override
    public JobTemplateSpec buildJobTemplate() {
        return this.jobTemplate != null ? this.jobTemplate.build() : null;
    }

    @Override
    public A withJobTemplate(JobTemplateSpec jobTemplate) {
        this._visitables.get("jobTemplate").remove(this.jobTemplate);
        if (jobTemplate != null) {
            this.jobTemplate = new JobTemplateSpecBuilder(jobTemplate);
            this._visitables.get("jobTemplate").add(this.jobTemplate);
        } else {
            this.jobTemplate = null;
            this._visitables.get("jobTemplate").remove(this.jobTemplate);
        }
        return (A)this;
    }

    @Override
    public Boolean hasJobTemplate() {
        return this.jobTemplate != null;
    }

    @Override
    public CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplate() {
        return new JobTemplateNestedImpl();
    }

    @Override
    public CronJobSpecFluent.JobTemplateNested<A> withNewJobTemplateLike(JobTemplateSpec item) {
        return new JobTemplateNestedImpl(item);
    }

    @Override
    public CronJobSpecFluent.JobTemplateNested<A> editJobTemplate() {
        return this.withNewJobTemplateLike(this.getJobTemplate());
    }

    @Override
    public CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplate() {
        return this.withNewJobTemplateLike(this.getJobTemplate() != null ? this.getJobTemplate() : new JobTemplateSpecBuilder().build());
    }

    @Override
    public CronJobSpecFluent.JobTemplateNested<A> editOrNewJobTemplateLike(JobTemplateSpec item) {
        return this.withNewJobTemplateLike(this.getJobTemplate() != null ? this.getJobTemplate() : item);
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)this;
    }

    @Override
    public Boolean hasSchedule() {
        return this.schedule != null;
    }

    @Override
    public Long getStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds;
    }

    @Override
    public A withStartingDeadlineSeconds(Long startingDeadlineSeconds) {
        this.startingDeadlineSeconds = startingDeadlineSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasStartingDeadlineSeconds() {
        return this.startingDeadlineSeconds != null;
    }

    @Override
    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    @Override
    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit != null;
    }

    @Override
    public Boolean getSuspend() {
        return this.suspend;
    }

    @Override
    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    @Override
    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    @Override
    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public A withTimeZone(String timeZone) {
        this.timeZone = timeZone;
        return (A)this;
    }

    @Override
    public Boolean hasTimeZone() {
        return this.timeZone != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CronJobSpecFluentImpl that = (CronJobSpecFluentImpl)o;
        if (!Objects.equals(this.concurrencyPolicy, that.concurrencyPolicy)) {
            return false;
        }
        if (!Objects.equals(this.failedJobsHistoryLimit, that.failedJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.jobTemplate, that.jobTemplate)) {
            return false;
        }
        if (!Objects.equals(this.schedule, that.schedule)) {
            return false;
        }
        if (!Objects.equals(this.startingDeadlineSeconds, that.startingDeadlineSeconds)) {
            return false;
        }
        if (!Objects.equals(this.successfulJobsHistoryLimit, that.successfulJobsHistoryLimit)) {
            return false;
        }
        if (!Objects.equals(this.suspend, that.suspend)) {
            return false;
        }
        if (!Objects.equals(this.timeZone, that.timeZone)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.concurrencyPolicy, this.failedJobsHistoryLimit, this.jobTemplate, this.schedule, this.startingDeadlineSeconds, this.successfulJobsHistoryLimit, this.suspend, this.timeZone, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.concurrencyPolicy != null) {
            sb.append("concurrencyPolicy:");
            sb.append(this.concurrencyPolicy + ",");
        }
        if (this.failedJobsHistoryLimit != null) {
            sb.append("failedJobsHistoryLimit:");
            sb.append(this.failedJobsHistoryLimit + ",");
        }
        if (this.jobTemplate != null) {
            sb.append("jobTemplate:");
            sb.append(this.jobTemplate + ",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule + ",");
        }
        if (this.startingDeadlineSeconds != null) {
            sb.append("startingDeadlineSeconds:");
            sb.append(this.startingDeadlineSeconds + ",");
        }
        if (this.successfulJobsHistoryLimit != null) {
            sb.append("successfulJobsHistoryLimit:");
            sb.append(this.successfulJobsHistoryLimit + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.timeZone != null) {
            sb.append("timeZone:");
            sb.append(this.timeZone + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withSuspend() {
        return this.withSuspend(true);
    }

    class JobTemplateNestedImpl<N>
    extends JobTemplateSpecFluentImpl<CronJobSpecFluent.JobTemplateNested<N>>
    implements CronJobSpecFluent.JobTemplateNested<N>,
    Nested<N> {
        JobTemplateSpecBuilder builder;

        JobTemplateNestedImpl(JobTemplateSpec item) {
            this.builder = new JobTemplateSpecBuilder(this, item);
        }

        JobTemplateNestedImpl() {
            this.builder = new JobTemplateSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)CronJobSpecFluentImpl.this.withJobTemplate(this.builder.build());
        }

        @Override
        public N endJobTemplate() {
            return this.and();
        }
    }
}

