/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_7.admissionregistration.v1alpha1.NamedRuleWithOperations;
import io.fabric8.kubernetes.api.model.v6_7.admissionregistration.v1alpha1.NamedRuleWithOperationsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class NamedRuleWithOperationsFluentImpl<A extends NamedRuleWithOperationsFluent<A>>
extends BaseFluent<A>
implements NamedRuleWithOperationsFluent<A> {
    private List<String> apiGroups = new ArrayList<String>();
    private List<String> apiVersions = new ArrayList<String>();
    private List<String> operations = new ArrayList<String>();
    private List<String> resourceNames = new ArrayList<String>();
    private List<String> resources = new ArrayList<String>();
    private String scope;
    private Map<String, Object> additionalProperties;

    public NamedRuleWithOperationsFluentImpl() {
    }

    public NamedRuleWithOperationsFluentImpl(NamedRuleWithOperations instance) {
        if (instance != null) {
            this.withApiGroups(instance.getApiGroups());
            this.withApiVersions(instance.getApiVersions());
            this.withOperations(instance.getOperations());
            this.withResourceNames(instance.getResourceNames());
            this.withResources(instance.getResources());
            this.withScope(instance.getScope());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.add(index, item);
        return (A)this;
    }

    @Override
    public A setToApiGroups(int index, String item) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        this.apiGroups.set(index, item);
        return (A)this;
    }

    @Override
    public A addToApiGroups(String ... items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToApiGroups(Collection<String> items) {
        if (this.apiGroups == null) {
            this.apiGroups = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiGroups.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromApiGroups(String ... items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromApiGroups(Collection<String> items) {
        for (String item : items) {
            if (this.apiGroups == null) continue;
            this.apiGroups.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getApiGroups() {
        return this.apiGroups;
    }

    @Override
    public String getApiGroup(int index) {
        return this.apiGroups.get(index);
    }

    @Override
    public String getFirstApiGroup() {
        return this.apiGroups.get(0);
    }

    @Override
    public String getLastApiGroup() {
        return this.apiGroups.get(this.apiGroups.size() - 1);
    }

    @Override
    public String getMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingApiGroup(Predicate<String> predicate) {
        for (String item : this.apiGroups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withApiGroups(List<String> apiGroups) {
        if (apiGroups != null) {
            this.apiGroups = new ArrayList<String>();
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        } else {
            this.apiGroups = null;
        }
        return (A)this;
    }

    @Override
    public A withApiGroups(String ... apiGroups) {
        if (this.apiGroups != null) {
            this.apiGroups.clear();
            this._visitables.remove("apiGroups");
        }
        if (apiGroups != null) {
            for (String item : apiGroups) {
                this.addToApiGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasApiGroups() {
        return this.apiGroups != null && !this.apiGroups.isEmpty();
    }

    @Override
    public A addToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToApiVersions(int index, String item) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        this.apiVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToApiVersions(String ... items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToApiVersions(Collection<String> items) {
        if (this.apiVersions == null) {
            this.apiVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.apiVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromApiVersions(String ... items) {
        for (String item : items) {
            if (this.apiVersions == null) continue;
            this.apiVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromApiVersions(Collection<String> items) {
        for (String item : items) {
            if (this.apiVersions == null) continue;
            this.apiVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getApiVersions() {
        return this.apiVersions;
    }

    @Override
    public String getApiVersion(int index) {
        return this.apiVersions.get(index);
    }

    @Override
    public String getFirstApiVersion() {
        return this.apiVersions.get(0);
    }

    @Override
    public String getLastApiVersion() {
        return this.apiVersions.get(this.apiVersions.size() - 1);
    }

    @Override
    public String getMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingApiVersion(Predicate<String> predicate) {
        for (String item : this.apiVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withApiVersions(List<String> apiVersions) {
        if (apiVersions != null) {
            this.apiVersions = new ArrayList<String>();
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        } else {
            this.apiVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withApiVersions(String ... apiVersions) {
        if (this.apiVersions != null) {
            this.apiVersions.clear();
            this._visitables.remove("apiVersions");
        }
        if (apiVersions != null) {
            for (String item : apiVersions) {
                this.addToApiVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasApiVersions() {
        return this.apiVersions != null && !this.apiVersions.isEmpty();
    }

    @Override
    public A addToOperations(int index, String item) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOperations(int index, String item) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        this.operations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOperations(String ... items) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        for (String item : items) {
            this.operations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOperations(Collection<String> items) {
        if (this.operations == null) {
            this.operations = new ArrayList<String>();
        }
        for (String item : items) {
            this.operations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOperations(String ... items) {
        for (String item : items) {
            if (this.operations == null) continue;
            this.operations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOperations(Collection<String> items) {
        for (String item : items) {
            if (this.operations == null) continue;
            this.operations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getOperations() {
        return this.operations;
    }

    @Override
    public String getOperation(int index) {
        return this.operations.get(index);
    }

    @Override
    public String getFirstOperation() {
        return this.operations.get(0);
    }

    @Override
    public String getLastOperation() {
        return this.operations.get(this.operations.size() - 1);
    }

    @Override
    public String getMatchingOperation(Predicate<String> predicate) {
        for (String item : this.operations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOperation(Predicate<String> predicate) {
        for (String item : this.operations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOperations(List<String> operations) {
        if (operations != null) {
            this.operations = new ArrayList<String>();
            for (String item : operations) {
                this.addToOperations(item);
            }
        } else {
            this.operations = null;
        }
        return (A)this;
    }

    @Override
    public A withOperations(String ... operations) {
        if (this.operations != null) {
            this.operations.clear();
            this._visitables.remove("operations");
        }
        if (operations != null) {
            for (String item : operations) {
                this.addToOperations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOperations() {
        return this.operations != null && !this.operations.isEmpty();
    }

    @Override
    public A addToResourceNames(int index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResourceNames(int index, String item) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        this.resourceNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResourceNames(String ... items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResourceNames(Collection<String> items) {
        if (this.resourceNames == null) {
            this.resourceNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.resourceNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResourceNames(String ... items) {
        for (String item : items) {
            if (this.resourceNames == null) continue;
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResourceNames(Collection<String> items) {
        for (String item : items) {
            if (this.resourceNames == null) continue;
            this.resourceNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResourceNames() {
        return this.resourceNames;
    }

    @Override
    public String getResourceName(int index) {
        return this.resourceNames.get(index);
    }

    @Override
    public String getFirstResourceName() {
        return this.resourceNames.get(0);
    }

    @Override
    public String getLastResourceName() {
        return this.resourceNames.get(this.resourceNames.size() - 1);
    }

    @Override
    public String getMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResourceName(Predicate<String> predicate) {
        for (String item : this.resourceNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResourceNames(List<String> resourceNames) {
        if (resourceNames != null) {
            this.resourceNames = new ArrayList<String>();
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        } else {
            this.resourceNames = null;
        }
        return (A)this;
    }

    @Override
    public A withResourceNames(String ... resourceNames) {
        if (this.resourceNames != null) {
            this.resourceNames.clear();
            this._visitables.remove("resourceNames");
        }
        if (resourceNames != null) {
            for (String item : resourceNames) {
                this.addToResourceNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResourceNames() {
        return this.resourceNames != null && !this.resourceNames.isEmpty();
    }

    @Override
    public A addToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.add(index, item);
        return (A)this;
    }

    @Override
    public A setToResources(int index, String item) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        this.resources.set(index, item);
        return (A)this;
    }

    @Override
    public A addToResources(String ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<String> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<String>();
        }
        for (String item : items) {
            this.resources.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(String ... items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<String> items) {
        for (String item : items) {
            if (this.resources == null) continue;
            this.resources.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getResources() {
        return this.resources;
    }

    @Override
    public String getResource(int index) {
        return this.resources.get(index);
    }

    @Override
    public String getFirstResource() {
        return this.resources.get(0);
    }

    @Override
    public String getLastResource() {
        return this.resources.get(this.resources.size() - 1);
    }

    @Override
    public String getMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<String> predicate) {
        for (String item : this.resources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<String> resources) {
        if (resources != null) {
            this.resources = new ArrayList<String>();
            for (String item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = null;
        }
        return (A)this;
    }

    @Override
    public A withResources(String ... resources) {
        if (this.resources != null) {
            this.resources.clear();
            this._visitables.remove("resources");
        }
        if (resources != null) {
            for (String item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    @Override
    public Boolean hasScope() {
        return this.scope != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedRuleWithOperationsFluentImpl that = (NamedRuleWithOperationsFluentImpl)o;
        if (!Objects.equals(this.apiGroups, that.apiGroups)) {
            return false;
        }
        if (!Objects.equals(this.apiVersions, that.apiVersions)) {
            return false;
        }
        if (!Objects.equals(this.operations, that.operations)) {
            return false;
        }
        if (!Objects.equals(this.resourceNames, that.resourceNames)) {
            return false;
        }
        if (!Objects.equals(this.resources, that.resources)) {
            return false;
        }
        if (!Objects.equals(this.scope, that.scope)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiGroups, this.apiVersions, this.operations, this.resourceNames, this.resources, this.scope, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiGroups != null && !this.apiGroups.isEmpty()) {
            sb.append("apiGroups:");
            sb.append(this.apiGroups + ",");
        }
        if (this.apiVersions != null && !this.apiVersions.isEmpty()) {
            sb.append("apiVersions:");
            sb.append(this.apiVersions + ",");
        }
        if (this.operations != null && !this.operations.isEmpty()) {
            sb.append("operations:");
            sb.append(this.operations + ",");
        }
        if (this.resourceNames != null && !this.resourceNames.isEmpty()) {
            sb.append("resourceNames:");
            sb.append(this.resourceNames + ",");
        }
        if (this.resources != null && !this.resources.isEmpty()) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.scope != null) {
            sb.append("scope:");
            sb.append(this.scope + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

