/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_7.RootPaths;
import io.fabric8.kubernetes.api.model.v6_7.RootPathsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RootPathsFluentImpl<A extends RootPathsFluent<A>>
extends BaseFluent<A>
implements RootPathsFluent<A> {
    private List<String> paths = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public RootPathsFluentImpl() {
    }

    public RootPathsFluentImpl(RootPaths instance) {
        if (instance != null) {
            this.withPaths(instance.getPaths());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPaths(int index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPaths(String ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<String> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(String ... items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<String> items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public String getPath(int index) {
        return this.paths.get(index);
    }

    @Override
    public String getFirstPath() {
        return this.paths.get(0);
    }

    @Override
    public String getLastPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    @Override
    public String getMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<String> paths) {
        if (paths != null) {
            this.paths = new ArrayList<String>();
            for (String item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(String ... paths) {
        if (this.paths != null) {
            this.paths.clear();
            this._visitables.remove("paths");
        }
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RootPathsFluentImpl that = (RootPathsFluentImpl)o;
        if (!Objects.equals(this.paths, that.paths)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.paths, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.paths != null && !this.paths.isEmpty()) {
            sb.append("paths:");
            sb.append(this.paths + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

