/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_7.PodExecOptions;
import io.fabric8.kubernetes.api.model.v6_7.PodExecOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class PodExecOptionsFluentImpl<A extends PodExecOptionsFluent<A>>
extends BaseFluent<A>
implements PodExecOptionsFluent<A> {
    private String apiVersion;
    private List<String> command = new ArrayList<String>();
    private String container;
    private String kind;
    private Boolean stderr;
    private Boolean stdin;
    private Boolean stdout;
    private Boolean tty;
    private Map<String, Object> additionalProperties;

    public PodExecOptionsFluentImpl() {
    }

    public PodExecOptionsFluentImpl(PodExecOptions instance) {
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withCommand(instance.getCommand());
            this.withContainer(instance.getContainer());
            this.withKind(instance.getKind());
            this.withStderr(instance.getStderr());
            this.withStdin(instance.getStdin());
            this.withStdout(instance.getStdout());
            this.withTty(instance.getTty());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCommand(List<String> command) {
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
            this._visitables.remove("command");
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public Boolean getStderr() {
        return this.stderr;
    }

    @Override
    public A withStderr(Boolean stderr) {
        this.stderr = stderr;
        return (A)this;
    }

    @Override
    public Boolean hasStderr() {
        return this.stderr != null;
    }

    @Override
    public Boolean getStdin() {
        return this.stdin;
    }

    @Override
    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    @Override
    public Boolean hasStdin() {
        return this.stdin != null;
    }

    @Override
    public Boolean getStdout() {
        return this.stdout;
    }

    @Override
    public A withStdout(Boolean stdout) {
        this.stdout = stdout;
        return (A)this;
    }

    @Override
    public Boolean hasStdout() {
        return this.stdout != null;
    }

    @Override
    public Boolean getTty() {
        return this.tty;
    }

    @Override
    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    @Override
    public Boolean hasTty() {
        return this.tty != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodExecOptionsFluentImpl that = (PodExecOptionsFluentImpl)o;
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.command, that.command)) {
            return false;
        }
        if (!Objects.equals(this.container, that.container)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.stderr, that.stderr)) {
            return false;
        }
        if (!Objects.equals(this.stdin, that.stdin)) {
            return false;
        }
        if (!Objects.equals(this.stdout, that.stdout)) {
            return false;
        }
        if (!Objects.equals(this.tty, that.tty)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.command, this.container, this.kind, this.stderr, this.stdin, this.stdout, this.tty, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.command != null && !this.command.isEmpty()) {
            sb.append("command:");
            sb.append(this.command + ",");
        }
        if (this.container != null) {
            sb.append("container:");
            sb.append(this.container + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.stderr != null) {
            sb.append("stderr:");
            sb.append(this.stderr + ",");
        }
        if (this.stdin != null) {
            sb.append("stdin:");
            sb.append(this.stdin + ",");
        }
        if (this.stdout != null) {
            sb.append("stdout:");
            sb.append(this.stdout + ",");
        }
        if (this.tty != null) {
            sb.append("tty:");
            sb.append(this.tty + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withStderr() {
        return this.withStderr(true);
    }

    @Override
    public A withStdin() {
        return this.withStdin(true);
    }

    @Override
    public A withStdout() {
        return this.withStdout(true);
    }

    @Override
    public A withTty() {
        return this.withTty(true);
    }
}

