/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_7.Nested;
import io.fabric8.kubernetes.api.model.v6_7.ManagedFieldsEntry;
import io.fabric8.kubernetes.api.model.v6_7.ManagedFieldsEntryBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ManagedFieldsEntryFluentImpl;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_7.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.v6_7.OwnerReference;
import io.fabric8.kubernetes.api.model.v6_7.OwnerReferenceBuilder;
import io.fabric8.kubernetes.api.model.v6_7.OwnerReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ObjectMetaFluentImpl<A extends ObjectMetaFluent<A>>
extends BaseFluent<A>
implements ObjectMetaFluent<A> {
    private Map<String, String> annotations;
    private String creationTimestamp;
    private Long deletionGracePeriodSeconds;
    private String deletionTimestamp;
    private List<String> finalizers = new ArrayList<String>();
    private String generateName;
    private Long generation;
    private Map<String, String> labels;
    private ArrayList<ManagedFieldsEntryBuilder> managedFields = new ArrayList();
    private String name;
    private String namespace;
    private ArrayList<OwnerReferenceBuilder> ownerReferences = new ArrayList();
    private String resourceVersion;
    private String selfLink;
    private String uid;
    private Map<String, Object> additionalProperties;

    public ObjectMetaFluentImpl() {
    }

    public ObjectMetaFluentImpl(ObjectMeta instance) {
        if (instance != null) {
            this.withAnnotations(instance.getAnnotations());
            this.withCreationTimestamp(instance.getCreationTimestamp());
            this.withDeletionGracePeriodSeconds(instance.getDeletionGracePeriodSeconds());
            this.withDeletionTimestamp(instance.getDeletionTimestamp());
            this.withFinalizers(instance.getFinalizers());
            this.withGenerateName(instance.getGenerateName());
            this.withGeneration(instance.getGeneration());
            this.withLabels(instance.getLabels());
            this.withManagedFields(instance.getManagedFields());
            this.withName(instance.getName());
            this.withNamespace(instance.getNamespace());
            this.withOwnerReferences(instance.getOwnerReferences());
            this.withResourceVersion(instance.getResourceVersion());
            this.withSelfLink(instance.getSelfLink());
            this.withUid(instance.getUid());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    @Override
    public A addToAnnotations(String key, String value) {
        if (this.annotations == null && key != null && value != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.annotations.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAnnotations(Map<String, String> map) {
        if (this.annotations == null && map != null) {
            this.annotations = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.annotations.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(String key) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (key != null && this.annotations != null) {
            this.annotations.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAnnotations(Map<String, String> map) {
        if (this.annotations == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.annotations == null) continue;
                this.annotations.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    @Override
    public <K, V> A withAnnotations(Map<String, String> annotations) {
        this.annotations = annotations == null ? null : new LinkedHashMap<String, String>(annotations);
        return (A)this;
    }

    @Override
    public Boolean hasAnnotations() {
        return this.annotations != null;
    }

    @Override
    public String getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Override
    public A withCreationTimestamp(String creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasCreationTimestamp() {
        return this.creationTimestamp != null;
    }

    @Override
    public Long getDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds;
    }

    @Override
    public A withDeletionGracePeriodSeconds(Long deletionGracePeriodSeconds) {
        this.deletionGracePeriodSeconds = deletionGracePeriodSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionGracePeriodSeconds() {
        return this.deletionGracePeriodSeconds != null;
    }

    @Override
    public String getDeletionTimestamp() {
        return this.deletionTimestamp;
    }

    @Override
    public A withDeletionTimestamp(String deletionTimestamp) {
        this.deletionTimestamp = deletionTimestamp;
        return (A)this;
    }

    @Override
    public Boolean hasDeletionTimestamp() {
        return this.deletionTimestamp != null;
    }

    @Override
    public A addToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.add(index, item);
        return (A)this;
    }

    @Override
    public A setToFinalizers(int index, String item) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        this.finalizers.set(index, item);
        return (A)this;
    }

    @Override
    public A addToFinalizers(String ... items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToFinalizers(Collection<String> items) {
        if (this.finalizers == null) {
            this.finalizers = new ArrayList<String>();
        }
        for (String item : items) {
            this.finalizers.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromFinalizers(String ... items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromFinalizers(Collection<String> items) {
        for (String item : items) {
            if (this.finalizers == null) continue;
            this.finalizers.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getFinalizers() {
        return this.finalizers;
    }

    @Override
    public String getFinalizer(int index) {
        return this.finalizers.get(index);
    }

    @Override
    public String getFirstFinalizer() {
        return this.finalizers.get(0);
    }

    @Override
    public String getLastFinalizer() {
        return this.finalizers.get(this.finalizers.size() - 1);
    }

    @Override
    public String getMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingFinalizer(Predicate<String> predicate) {
        for (String item : this.finalizers) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withFinalizers(List<String> finalizers) {
        if (finalizers != null) {
            this.finalizers = new ArrayList<String>();
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        } else {
            this.finalizers = null;
        }
        return (A)this;
    }

    @Override
    public A withFinalizers(String ... finalizers) {
        if (this.finalizers != null) {
            this.finalizers.clear();
            this._visitables.remove("finalizers");
        }
        if (finalizers != null) {
            for (String item : finalizers) {
                this.addToFinalizers(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasFinalizers() {
        return this.finalizers != null && !this.finalizers.isEmpty();
    }

    @Override
    public String getGenerateName() {
        return this.generateName;
    }

    @Override
    public A withGenerateName(String generateName) {
        this.generateName = generateName;
        return (A)this;
    }

    @Override
    public Boolean hasGenerateName() {
        return this.generateName != null;
    }

    @Override
    public Long getGeneration() {
        return this.generation;
    }

    @Override
    public A withGeneration(Long generation) {
        this.generation = generation;
        return (A)this;
    }

    @Override
    public Boolean hasGeneration() {
        return this.generation != null;
    }

    @Override
    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)this;
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getLabels() {
        return this.labels;
    }

    @Override
    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)this;
    }

    @Override
    public Boolean hasLabels() {
        return this.labels != null;
    }

    @Override
    public A addToManagedFields(int index, ManagedFieldsEntry item) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        ManagedFieldsEntryBuilder builder = new ManagedFieldsEntryBuilder(item);
        if (index < 0 || index >= this.managedFields.size()) {
            this._visitables.get("managedFields").add(builder);
            this.managedFields.add(builder);
        } else {
            this._visitables.get("managedFields").add(index, builder);
            this.managedFields.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToManagedFields(int index, ManagedFieldsEntry item) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        ManagedFieldsEntryBuilder builder = new ManagedFieldsEntryBuilder(item);
        if (index < 0 || index >= this.managedFields.size()) {
            this._visitables.get("managedFields").add(builder);
            this.managedFields.add(builder);
        } else {
            this._visitables.get("managedFields").set(index, builder);
            this.managedFields.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToManagedFields(ManagedFieldsEntry ... items) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        for (ManagedFieldsEntry item : items) {
            ManagedFieldsEntryBuilder builder = new ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").add(builder);
            this.managedFields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToManagedFields(Collection<ManagedFieldsEntry> items) {
        if (this.managedFields == null) {
            this.managedFields = new ArrayList();
        }
        for (ManagedFieldsEntry item : items) {
            ManagedFieldsEntryBuilder builder = new ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").add(builder);
            this.managedFields.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromManagedFields(ManagedFieldsEntry ... items) {
        for (ManagedFieldsEntry item : items) {
            ManagedFieldsEntryBuilder builder = new ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").remove(builder);
            if (this.managedFields == null) continue;
            this.managedFields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromManagedFields(Collection<ManagedFieldsEntry> items) {
        for (ManagedFieldsEntry item : items) {
            ManagedFieldsEntryBuilder builder = new ManagedFieldsEntryBuilder(item);
            this._visitables.get("managedFields").remove(builder);
            if (this.managedFields == null) continue;
            this.managedFields.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromManagedFields(Predicate<ManagedFieldsEntryBuilder> predicate) {
        if (this.managedFields == null) {
            return (A)this;
        }
        Iterator<ManagedFieldsEntryBuilder> each = this.managedFields.iterator();
        Object visitables = this._visitables.get("managedFields");
        while (each.hasNext()) {
            ManagedFieldsEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ManagedFieldsEntry> getManagedFields() {
        return this.managedFields != null ? ObjectMetaFluentImpl.build(this.managedFields) : null;
    }

    @Override
    public List<ManagedFieldsEntry> buildManagedFields() {
        return this.managedFields != null ? ObjectMetaFluentImpl.build(this.managedFields) : null;
    }

    @Override
    public ManagedFieldsEntry buildManagedField(int index) {
        return this.managedFields.get(index).build();
    }

    @Override
    public ManagedFieldsEntry buildFirstManagedField() {
        return this.managedFields.get(0).build();
    }

    @Override
    public ManagedFieldsEntry buildLastManagedField() {
        return this.managedFields.get(this.managedFields.size() - 1).build();
    }

    @Override
    public ManagedFieldsEntry buildMatchingManagedField(Predicate<ManagedFieldsEntryBuilder> predicate) {
        for (ManagedFieldsEntryBuilder item : this.managedFields) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingManagedField(Predicate<ManagedFieldsEntryBuilder> predicate) {
        for (ManagedFieldsEntryBuilder item : this.managedFields) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withManagedFields(List<ManagedFieldsEntry> managedFields) {
        if (this.managedFields != null) {
            this._visitables.get("managedFields").clear();
        }
        if (managedFields != null) {
            this.managedFields = new ArrayList();
            for (ManagedFieldsEntry item : managedFields) {
                this.addToManagedFields(item);
            }
        } else {
            this.managedFields = null;
        }
        return (A)this;
    }

    @Override
    public A withManagedFields(ManagedFieldsEntry ... managedFields) {
        if (this.managedFields != null) {
            this.managedFields.clear();
            this._visitables.remove("managedFields");
        }
        if (managedFields != null) {
            for (ManagedFieldsEntry item : managedFields) {
                this.addToManagedFields(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasManagedFields() {
        return this.managedFields != null && !this.managedFields.isEmpty();
    }

    @Override
    public ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedField() {
        return new ManagedFieldsNestedImpl();
    }

    @Override
    public ObjectMetaFluent.ManagedFieldsNested<A> addNewManagedFieldLike(ManagedFieldsEntry item) {
        return new ManagedFieldsNestedImpl(-1, item);
    }

    @Override
    public ObjectMetaFluent.ManagedFieldsNested<A> setNewManagedFieldLike(int index, ManagedFieldsEntry item) {
        return new ManagedFieldsNestedImpl(index, item);
    }

    @Override
    public ObjectMetaFluent.ManagedFieldsNested<A> editManagedField(int index) {
        if (this.managedFields.size() <= index) {
            throw new RuntimeException("Can't edit managedFields. Index exceeds size.");
        }
        return this.setNewManagedFieldLike(index, this.buildManagedField(index));
    }

    @Override
    public ObjectMetaFluent.ManagedFieldsNested<A> editFirstManagedField() {
        if (this.managedFields.size() == 0) {
            throw new RuntimeException("Can't edit first managedFields. The list is empty.");
        }
        return this.setNewManagedFieldLike(0, this.buildManagedField(0));
    }

    @Override
    public ObjectMetaFluent.ManagedFieldsNested<A> editLastManagedField() {
        int index = this.managedFields.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last managedFields. The list is empty.");
        }
        return this.setNewManagedFieldLike(index, this.buildManagedField(index));
    }

    @Override
    public ObjectMetaFluent.ManagedFieldsNested<A> editMatchingManagedField(Predicate<ManagedFieldsEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.managedFields.size(); ++i) {
            if (!predicate.test(this.managedFields.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching managedFields. No match found.");
        }
        return this.setNewManagedFieldLike(index, this.buildManagedField(index));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public A withNamespace(String namespace) {
        this.namespace = namespace;
        return (A)this;
    }

    @Override
    public Boolean hasNamespace() {
        return this.namespace != null;
    }

    @Override
    public A addToOwnerReferences(int index, OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
        if (index < 0 || index >= this.ownerReferences.size()) {
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        } else {
            this._visitables.get("ownerReferences").add(index, builder);
            this.ownerReferences.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToOwnerReferences(int index, OwnerReference item) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
        if (index < 0 || index >= this.ownerReferences.size()) {
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        } else {
            this._visitables.get("ownerReferences").set(index, builder);
            this.ownerReferences.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToOwnerReferences(OwnerReference ... items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        for (OwnerReference item : items) {
            OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToOwnerReferences(Collection<OwnerReference> items) {
        if (this.ownerReferences == null) {
            this.ownerReferences = new ArrayList();
        }
        for (OwnerReference item : items) {
            OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").add(builder);
            this.ownerReferences.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromOwnerReferences(OwnerReference ... items) {
        for (OwnerReference item : items) {
            OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").remove(builder);
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOwnerReferences(Collection<OwnerReference> items) {
        for (OwnerReference item : items) {
            OwnerReferenceBuilder builder = new OwnerReferenceBuilder(item);
            this._visitables.get("ownerReferences").remove(builder);
            if (this.ownerReferences == null) continue;
            this.ownerReferences.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromOwnerReferences(Predicate<OwnerReferenceBuilder> predicate) {
        if (this.ownerReferences == null) {
            return (A)this;
        }
        Iterator<OwnerReferenceBuilder> each = this.ownerReferences.iterator();
        Object visitables = this._visitables.get("ownerReferences");
        while (each.hasNext()) {
            OwnerReferenceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<OwnerReference> getOwnerReferences() {
        return this.ownerReferences != null ? ObjectMetaFluentImpl.build(this.ownerReferences) : null;
    }

    @Override
    public List<OwnerReference> buildOwnerReferences() {
        return this.ownerReferences != null ? ObjectMetaFluentImpl.build(this.ownerReferences) : null;
    }

    @Override
    public OwnerReference buildOwnerReference(int index) {
        return this.ownerReferences.get(index).build();
    }

    @Override
    public OwnerReference buildFirstOwnerReference() {
        return this.ownerReferences.get(0).build();
    }

    @Override
    public OwnerReference buildLastOwnerReference() {
        return this.ownerReferences.get(this.ownerReferences.size() - 1).build();
    }

    @Override
    public OwnerReference buildMatchingOwnerReference(Predicate<OwnerReferenceBuilder> predicate) {
        for (OwnerReferenceBuilder item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOwnerReference(Predicate<OwnerReferenceBuilder> predicate) {
        for (OwnerReferenceBuilder item : this.ownerReferences) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOwnerReferences(List<OwnerReference> ownerReferences) {
        if (this.ownerReferences != null) {
            this._visitables.get("ownerReferences").clear();
        }
        if (ownerReferences != null) {
            this.ownerReferences = new ArrayList();
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        } else {
            this.ownerReferences = null;
        }
        return (A)this;
    }

    @Override
    public A withOwnerReferences(OwnerReference ... ownerReferences) {
        if (this.ownerReferences != null) {
            this.ownerReferences.clear();
            this._visitables.remove("ownerReferences");
        }
        if (ownerReferences != null) {
            for (OwnerReference item : ownerReferences) {
                this.addToOwnerReferences(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOwnerReferences() {
        return this.ownerReferences != null && !this.ownerReferences.isEmpty();
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReference() {
        return new OwnerReferencesNestedImpl();
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> addNewOwnerReferenceLike(OwnerReference item) {
        return new OwnerReferencesNestedImpl(-1, item);
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> setNewOwnerReferenceLike(int index, OwnerReference item) {
        return new OwnerReferencesNestedImpl(index, item);
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> editOwnerReference(int index) {
        if (this.ownerReferences.size() <= index) {
            throw new RuntimeException("Can't edit ownerReferences. Index exceeds size.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> editFirstOwnerReference() {
        if (this.ownerReferences.size() == 0) {
            throw new RuntimeException("Can't edit first ownerReferences. The list is empty.");
        }
        return this.setNewOwnerReferenceLike(0, this.buildOwnerReference(0));
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> editLastOwnerReference() {
        int index = this.ownerReferences.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ownerReferences. The list is empty.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public ObjectMetaFluent.OwnerReferencesNested<A> editMatchingOwnerReference(Predicate<OwnerReferenceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ownerReferences.size(); ++i) {
            if (!predicate.test(this.ownerReferences.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ownerReferences. No match found.");
        }
        return this.setNewOwnerReferenceLike(index, this.buildOwnerReference(index));
    }

    @Override
    public String getResourceVersion() {
        return this.resourceVersion;
    }

    @Override
    public A withResourceVersion(String resourceVersion) {
        this.resourceVersion = resourceVersion;
        return (A)this;
    }

    @Override
    public Boolean hasResourceVersion() {
        return this.resourceVersion != null;
    }

    @Override
    public String getSelfLink() {
        return this.selfLink;
    }

    @Override
    public A withSelfLink(String selfLink) {
        this.selfLink = selfLink;
        return (A)this;
    }

    @Override
    public Boolean hasSelfLink() {
        return this.selfLink != null;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public A withUid(String uid) {
        this.uid = uid;
        return (A)this;
    }

    @Override
    public Boolean hasUid() {
        return this.uid != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMetaFluentImpl that = (ObjectMetaFluentImpl)o;
        if (!Objects.equals(this.annotations, that.annotations)) {
            return false;
        }
        if (!Objects.equals(this.creationTimestamp, that.creationTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.deletionGracePeriodSeconds, that.deletionGracePeriodSeconds)) {
            return false;
        }
        if (!Objects.equals(this.deletionTimestamp, that.deletionTimestamp)) {
            return false;
        }
        if (!Objects.equals(this.finalizers, that.finalizers)) {
            return false;
        }
        if (!Objects.equals(this.generateName, that.generateName)) {
            return false;
        }
        if (!Objects.equals(this.generation, that.generation)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.managedFields, that.managedFields)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespace, that.namespace)) {
            return false;
        }
        if (!Objects.equals(this.ownerReferences, that.ownerReferences)) {
            return false;
        }
        if (!Objects.equals(this.resourceVersion, that.resourceVersion)) {
            return false;
        }
        if (!Objects.equals(this.selfLink, that.selfLink)) {
            return false;
        }
        if (!Objects.equals(this.uid, that.uid)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.annotations, this.creationTimestamp, this.deletionGracePeriodSeconds, this.deletionTimestamp, this.finalizers, this.generateName, this.generation, this.labels, this.managedFields, this.name, this.namespace, this.ownerReferences, this.resourceVersion, this.selfLink, this.uid, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.annotations != null && !this.annotations.isEmpty()) {
            sb.append("annotations:");
            sb.append(this.annotations + ",");
        }
        if (this.creationTimestamp != null) {
            sb.append("creationTimestamp:");
            sb.append(this.creationTimestamp + ",");
        }
        if (this.deletionGracePeriodSeconds != null) {
            sb.append("deletionGracePeriodSeconds:");
            sb.append(this.deletionGracePeriodSeconds + ",");
        }
        if (this.deletionTimestamp != null) {
            sb.append("deletionTimestamp:");
            sb.append(this.deletionTimestamp + ",");
        }
        if (this.finalizers != null && !this.finalizers.isEmpty()) {
            sb.append("finalizers:");
            sb.append(this.finalizers + ",");
        }
        if (this.generateName != null) {
            sb.append("generateName:");
            sb.append(this.generateName + ",");
        }
        if (this.generation != null) {
            sb.append("generation:");
            sb.append(this.generation + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(this.labels + ",");
        }
        if (this.managedFields != null && !this.managedFields.isEmpty()) {
            sb.append("managedFields:");
            sb.append(this.managedFields + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespace != null) {
            sb.append("namespace:");
            sb.append(this.namespace + ",");
        }
        if (this.ownerReferences != null && !this.ownerReferences.isEmpty()) {
            sb.append("ownerReferences:");
            sb.append(this.ownerReferences + ",");
        }
        if (this.resourceVersion != null) {
            sb.append("resourceVersion:");
            sb.append(this.resourceVersion + ",");
        }
        if (this.selfLink != null) {
            sb.append("selfLink:");
            sb.append(this.selfLink + ",");
        }
        if (this.uid != null) {
            sb.append("uid:");
            sb.append(this.uid + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class OwnerReferencesNestedImpl<N>
    extends OwnerReferenceFluentImpl<ObjectMetaFluent.OwnerReferencesNested<N>>
    implements ObjectMetaFluent.OwnerReferencesNested<N>,
    Nested<N> {
        OwnerReferenceBuilder builder;
        int index;

        OwnerReferencesNestedImpl(int index, OwnerReference item) {
            this.index = index;
            this.builder = new OwnerReferenceBuilder(this, item);
        }

        OwnerReferencesNestedImpl() {
            this.index = -1;
            this.builder = new OwnerReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetaFluentImpl.this.setToOwnerReferences(this.index, this.builder.build());
        }

        @Override
        public N endOwnerReference() {
            return this.and();
        }
    }

    class ManagedFieldsNestedImpl<N>
    extends ManagedFieldsEntryFluentImpl<ObjectMetaFluent.ManagedFieldsNested<N>>
    implements ObjectMetaFluent.ManagedFieldsNested<N>,
    Nested<N> {
        ManagedFieldsEntryBuilder builder;
        int index;

        ManagedFieldsNestedImpl(int index, ManagedFieldsEntry item) {
            this.index = index;
            this.builder = new ManagedFieldsEntryBuilder(this, item);
        }

        ManagedFieldsNestedImpl() {
            this.index = -1;
            this.builder = new ManagedFieldsEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ObjectMetaFluentImpl.this.setToManagedFields(this.index, this.builder.build());
        }

        @Override
        public N endManagedField() {
            return this.and();
        }
    }
}

