/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.NodeStatus;
import io.fabric8.kubernetes.api.model.v6_7.NodeStatusFluent;
import io.fabric8.kubernetes.api.model.v6_7.NodeStatusFluentImpl;

public class NodeStatusBuilder
extends NodeStatusFluentImpl<NodeStatusBuilder>
implements VisitableBuilder<NodeStatus, NodeStatusBuilder> {
    NodeStatusFluent<?> fluent;
    Boolean validationEnabled;

    public NodeStatusBuilder() {
        this(false);
    }

    public NodeStatusBuilder(Boolean validationEnabled) {
        this(new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NodeStatus(), validationEnabled);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance) {
        this(fluent, instance, false);
    }

    public NodeStatusBuilder(NodeStatusFluent<?> fluent, NodeStatus instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withAddresses(instance.getAddresses());
            fluent.withAllocatable(instance.getAllocatable());
            fluent.withCapacity(instance.getCapacity());
            fluent.withConditions(instance.getConditions());
            fluent.withConfig(instance.getConfig());
            fluent.withDaemonEndpoints(instance.getDaemonEndpoints());
            fluent.withImages(instance.getImages());
            fluent.withNodeInfo(instance.getNodeInfo());
            fluent.withPhase(instance.getPhase());
            fluent.withVolumesAttached(instance.getVolumesAttached());
            fluent.withVolumesInUse(instance.getVolumesInUse());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public NodeStatusBuilder(NodeStatus instance) {
        this(instance, (Boolean)false);
    }

    public NodeStatusBuilder(NodeStatus instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withAddresses(instance.getAddresses());
            this.withAllocatable(instance.getAllocatable());
            this.withCapacity(instance.getCapacity());
            this.withConditions(instance.getConditions());
            this.withConfig(instance.getConfig());
            this.withDaemonEndpoints(instance.getDaemonEndpoints());
            this.withImages(instance.getImages());
            this.withNodeInfo(instance.getNodeInfo());
            this.withPhase(instance.getPhase());
            this.withVolumesAttached(instance.getVolumesAttached());
            this.withVolumesInUse(instance.getVolumesInUse());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NodeStatus build() {
        NodeStatus buildable = new NodeStatus(this.fluent.getAddresses(), this.fluent.getAllocatable(), this.fluent.getCapacity(), this.fluent.getConditions(), this.fluent.getConfig(), this.fluent.getDaemonEndpoints(), this.fluent.getImages(), this.fluent.getNodeInfo(), this.fluent.getPhase(), this.fluent.getVolumesAttached(), this.fluent.getVolumesInUse());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

