/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_7;

import io.fabric8.kubernetes.api.builder.v6_7.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_7.ConfigMap;
import io.fabric8.kubernetes.api.model.v6_7.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.v6_7.ConfigMapFluentImpl;

public class ConfigMapBuilder
extends ConfigMapFluentImpl<ConfigMapBuilder>
implements VisitableBuilder<ConfigMap, ConfigMapBuilder> {
    ConfigMapFluent<?> fluent;
    Boolean validationEnabled;

    public ConfigMapBuilder() {
        this(false);
    }

    public ConfigMapBuilder(Boolean validationEnabled) {
        this(new ConfigMap(), validationEnabled);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ConfigMap(), validationEnabled);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent, ConfigMap instance) {
        this(fluent, instance, false);
    }

    public ConfigMapBuilder(ConfigMapFluent<?> fluent, ConfigMap instance, Boolean validationEnabled) {
        this.fluent = fluent;
        if (instance != null) {
            fluent.withApiVersion(instance.getApiVersion());
            fluent.withBinaryData(instance.getBinaryData());
            fluent.withData(instance.getData());
            fluent.withImmutable(instance.getImmutable());
            fluent.withKind(instance.getKind());
            fluent.withMetadata(instance.getMetadata());
            fluent.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    public ConfigMapBuilder(ConfigMap instance) {
        this(instance, (Boolean)false);
    }

    public ConfigMapBuilder(ConfigMap instance, Boolean validationEnabled) {
        this.fluent = this;
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withBinaryData(instance.getBinaryData());
            this.withData(instance.getData());
            this.withImmutable(instance.getImmutable());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ConfigMap build() {
        ConfigMap buildable = new ConfigMap(this.fluent.getApiVersion(), this.fluent.getBinaryData(), this.fluent.getData(), this.fluent.getImmutable(), this.fluent.getKind(), this.fluent.getMetadata());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

