/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v6_6.server.mock;

import io.fabric8.kubernetes.clnt.v6_6.KubernetesClient;
import io.fabric8.kubernetes.clnt.v6_6.server.mock.KubernetesMixedDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import io.fabric8.mockwebserver.dsl.ReturnOrWebsocketable;
import io.fabric8.mockwebserver.dsl.TimesOnceableOrHttpHeaderable;
import io.fabric8.openshift.clnt.v6_6.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v6_6.server.mock.OpenShiftMockServer;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.MockWebServer;
import okhttp3.mockwebserver.RecordedRequest;
import org.junit.rules.ExternalResource;

public class OpenShiftServer
extends ExternalResource {
    protected OpenShiftMockServer mock;
    private NamespacedOpenShiftClient client;
    private final boolean https;
    private final boolean crudMode;

    public OpenShiftServer() {
        this(true, false);
    }

    public OpenShiftServer(boolean https) {
        this(https, false);
    }

    public OpenShiftServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mock = this.crudMode ? new OpenShiftMockServer(new Context(), new MockWebServer(), responses, new KubernetesMixedDispatcher(responses), this.https) : new OpenShiftMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createOpenShiftClient();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public KubernetesClient getKubernetesClient() {
        return this.client;
    }

    public NamespacedOpenShiftClient getOpenshiftClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }

    @Deprecated
    public <T> void expectAndReturnAsJson(String path, int code, T body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, body)).always();
    }

    @Deprecated
    public void expectAndReturnAsString(String path, int code, String body) {
        ((TimesOnceableOrHttpHeaderable)((ReturnOrWebsocketable)this.expect().withPath(path)).andReturn(code, (Object)body)).always();
    }

    public OpenShiftMockServer getOpenShiftMockServer() {
        return this.mock;
    }

    public RecordedRequest getLastRequest() throws InterruptedException {
        return this.mock.getLastRequest();
    }
}

