/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.storage.v1beta1.CSIDriverSpec;
import io.fabric8.kubernetes.api.model.v6_6.storage.v1beta1.CSIDriverSpecFluent;
import io.fabric8.kubernetes.api.model.v6_6.storage.v1beta1.TokenRequest;
import io.fabric8.kubernetes.api.model.v6_6.storage.v1beta1.TokenRequestBuilder;
import io.fabric8.kubernetes.api.model.v6_6.storage.v1beta1.TokenRequestFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class CSIDriverSpecFluentImpl<A extends CSIDriverSpecFluent<A>>
extends BaseFluent<A>
implements CSIDriverSpecFluent<A> {
    private Boolean attachRequired;
    private String fsGroupPolicy;
    private Boolean podInfoOnMount;
    private Boolean requiresRepublish;
    private Boolean seLinuxMount;
    private Boolean storageCapacity;
    private ArrayList<TokenRequestBuilder> tokenRequests = new ArrayList();
    private List<String> volumeLifecycleModes = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public CSIDriverSpecFluentImpl() {
    }

    public CSIDriverSpecFluentImpl(CSIDriverSpec instance) {
        this.withAttachRequired(instance.getAttachRequired());
        this.withFsGroupPolicy(instance.getFsGroupPolicy());
        this.withPodInfoOnMount(instance.getPodInfoOnMount());
        this.withRequiresRepublish(instance.getRequiresRepublish());
        this.withSeLinuxMount(instance.getSeLinuxMount());
        this.withStorageCapacity(instance.getStorageCapacity());
        this.withTokenRequests(instance.getTokenRequests());
        this.withVolumeLifecycleModes(instance.getVolumeLifecycleModes());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Boolean getAttachRequired() {
        return this.attachRequired;
    }

    @Override
    public A withAttachRequired(Boolean attachRequired) {
        this.attachRequired = attachRequired;
        return (A)this;
    }

    @Override
    public Boolean hasAttachRequired() {
        return this.attachRequired != null;
    }

    @Override
    public String getFsGroupPolicy() {
        return this.fsGroupPolicy;
    }

    @Override
    public A withFsGroupPolicy(String fsGroupPolicy) {
        this.fsGroupPolicy = fsGroupPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFsGroupPolicy() {
        return this.fsGroupPolicy != null;
    }

    @Override
    public Boolean getPodInfoOnMount() {
        return this.podInfoOnMount;
    }

    @Override
    public A withPodInfoOnMount(Boolean podInfoOnMount) {
        this.podInfoOnMount = podInfoOnMount;
        return (A)this;
    }

    @Override
    public Boolean hasPodInfoOnMount() {
        return this.podInfoOnMount != null;
    }

    @Override
    public Boolean getRequiresRepublish() {
        return this.requiresRepublish;
    }

    @Override
    public A withRequiresRepublish(Boolean requiresRepublish) {
        this.requiresRepublish = requiresRepublish;
        return (A)this;
    }

    @Override
    public Boolean hasRequiresRepublish() {
        return this.requiresRepublish != null;
    }

    @Override
    public Boolean getSeLinuxMount() {
        return this.seLinuxMount;
    }

    @Override
    public A withSeLinuxMount(Boolean seLinuxMount) {
        this.seLinuxMount = seLinuxMount;
        return (A)this;
    }

    @Override
    public Boolean hasSeLinuxMount() {
        return this.seLinuxMount != null;
    }

    @Override
    public Boolean getStorageCapacity() {
        return this.storageCapacity;
    }

    @Override
    public A withStorageCapacity(Boolean storageCapacity) {
        this.storageCapacity = storageCapacity;
        return (A)this;
    }

    @Override
    public Boolean hasStorageCapacity() {
        return this.storageCapacity != null;
    }

    @Override
    public A addToTokenRequests(Integer index, TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        TokenRequestBuilder builder = new TokenRequestBuilder(item);
        this._visitables.get("tokenRequests").add(index >= 0 ? index.intValue() : this._visitables.get("tokenRequests").size(), builder);
        this.tokenRequests.add(index >= 0 ? index.intValue() : this.tokenRequests.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTokenRequests(Integer index, TokenRequest item) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        TokenRequestBuilder builder = new TokenRequestBuilder(item);
        if (index < 0 || index >= this._visitables.get("tokenRequests").size()) {
            this._visitables.get("tokenRequests").add(builder);
        } else {
            this._visitables.get("tokenRequests").set(index, builder);
        }
        if (index < 0 || index >= this.tokenRequests.size()) {
            this.tokenRequests.add(builder);
        } else {
            this.tokenRequests.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTokenRequests(TokenRequest ... items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTokenRequests(Collection<TokenRequest> items) {
        if (this.tokenRequests == null) {
            this.tokenRequests = new ArrayList();
        }
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").add(builder);
            this.tokenRequests.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTokenRequests(TokenRequest ... items) {
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").remove(builder);
            if (this.tokenRequests == null) continue;
            this.tokenRequests.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTokenRequests(Collection<TokenRequest> items) {
        for (TokenRequest item : items) {
            TokenRequestBuilder builder = new TokenRequestBuilder(item);
            this._visitables.get("tokenRequests").remove(builder);
            if (this.tokenRequests == null) continue;
            this.tokenRequests.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTokenRequests(Predicate<TokenRequestBuilder> predicate) {
        if (this.tokenRequests == null) {
            return (A)this;
        }
        Iterator<TokenRequestBuilder> each = this.tokenRequests.iterator();
        Object visitables = this._visitables.get("tokenRequests");
        while (each.hasNext()) {
            TokenRequestBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TokenRequest> getTokenRequests() {
        return this.tokenRequests != null ? CSIDriverSpecFluentImpl.build(this.tokenRequests) : null;
    }

    @Override
    public List<TokenRequest> buildTokenRequests() {
        return this.tokenRequests != null ? CSIDriverSpecFluentImpl.build(this.tokenRequests) : null;
    }

    @Override
    public TokenRequest buildTokenRequest(Integer index) {
        return this.tokenRequests.get(index).build();
    }

    @Override
    public TokenRequest buildFirstTokenRequest() {
        return this.tokenRequests.get(0).build();
    }

    @Override
    public TokenRequest buildLastTokenRequest() {
        return this.tokenRequests.get(this.tokenRequests.size() - 1).build();
    }

    @Override
    public TokenRequest buildMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        for (TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        for (TokenRequestBuilder item : this.tokenRequests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTokenRequests(List<TokenRequest> tokenRequests) {
        if (this.tokenRequests != null) {
            this._visitables.get("tokenRequests").removeAll(this.tokenRequests);
        }
        if (tokenRequests != null) {
            this.tokenRequests = new ArrayList();
            for (TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        } else {
            this.tokenRequests = null;
        }
        return (A)this;
    }

    @Override
    public A withTokenRequests(TokenRequest ... tokenRequests) {
        if (this.tokenRequests != null) {
            this.tokenRequests.clear();
        }
        if (tokenRequests != null) {
            for (TokenRequest item : tokenRequests) {
                this.addToTokenRequests(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTokenRequests() {
        return this.tokenRequests != null && !this.tokenRequests.isEmpty();
    }

    @Override
    public A addNewTokenRequest(String audience, Long expirationSeconds) {
        return this.addToTokenRequests(new TokenRequest(audience, expirationSeconds));
    }

    @Override
    public CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequest() {
        return new TokenRequestsNestedImpl();
    }

    @Override
    public CSIDriverSpecFluent.TokenRequestsNested<A> addNewTokenRequestLike(TokenRequest item) {
        return new TokenRequestsNestedImpl(-1, item);
    }

    @Override
    public CSIDriverSpecFluent.TokenRequestsNested<A> setNewTokenRequestLike(Integer index, TokenRequest item) {
        return new TokenRequestsNestedImpl(index, item);
    }

    @Override
    public CSIDriverSpecFluent.TokenRequestsNested<A> editTokenRequest(Integer index) {
        if (this.tokenRequests.size() <= index) {
            throw new RuntimeException("Can't edit tokenRequests. Index exceeds size.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    @Override
    public CSIDriverSpecFluent.TokenRequestsNested<A> editFirstTokenRequest() {
        if (this.tokenRequests.size() == 0) {
            throw new RuntimeException("Can't edit first tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(0, this.buildTokenRequest(0));
    }

    @Override
    public CSIDriverSpecFluent.TokenRequestsNested<A> editLastTokenRequest() {
        int index = this.tokenRequests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tokenRequests. The list is empty.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    @Override
    public CSIDriverSpecFluent.TokenRequestsNested<A> editMatchingTokenRequest(Predicate<TokenRequestBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tokenRequests.size(); ++i) {
            if (!predicate.test(this.tokenRequests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tokenRequests. No match found.");
        }
        return this.setNewTokenRequestLike(index, this.buildTokenRequest(index));
    }

    @Override
    public A addToVolumeLifecycleModes(Integer index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumeLifecycleModes(Integer index, String item) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        this.volumeLifecycleModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumeLifecycleModes(String ... items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumeLifecycleModes(Collection<String> items) {
        if (this.volumeLifecycleModes == null) {
            this.volumeLifecycleModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.volumeLifecycleModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumeLifecycleModes(String ... items) {
        for (String item : items) {
            if (this.volumeLifecycleModes == null) continue;
            this.volumeLifecycleModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumeLifecycleModes(Collection<String> items) {
        for (String item : items) {
            if (this.volumeLifecycleModes == null) continue;
            this.volumeLifecycleModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getVolumeLifecycleModes() {
        return this.volumeLifecycleModes;
    }

    @Override
    public String getVolumeLifecycleMode(Integer index) {
        return this.volumeLifecycleModes.get(index);
    }

    @Override
    public String getFirstVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(0);
    }

    @Override
    public String getLastVolumeLifecycleMode() {
        return this.volumeLifecycleModes.get(this.volumeLifecycleModes.size() - 1);
    }

    @Override
    public String getMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolumeLifecycleMode(Predicate<String> predicate) {
        for (String item : this.volumeLifecycleModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumeLifecycleModes(List<String> volumeLifecycleModes) {
        if (volumeLifecycleModes != null) {
            this.volumeLifecycleModes = new ArrayList<String>();
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        } else {
            this.volumeLifecycleModes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumeLifecycleModes(String ... volumeLifecycleModes) {
        if (this.volumeLifecycleModes != null) {
            this.volumeLifecycleModes.clear();
        }
        if (volumeLifecycleModes != null) {
            for (String item : volumeLifecycleModes) {
                this.addToVolumeLifecycleModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumeLifecycleModes() {
        return this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CSIDriverSpecFluentImpl that = (CSIDriverSpecFluentImpl)o;
        if (this.attachRequired != null ? !this.attachRequired.equals(that.attachRequired) : that.attachRequired != null) {
            return false;
        }
        if (this.fsGroupPolicy != null ? !this.fsGroupPolicy.equals(that.fsGroupPolicy) : that.fsGroupPolicy != null) {
            return false;
        }
        if (this.podInfoOnMount != null ? !this.podInfoOnMount.equals(that.podInfoOnMount) : that.podInfoOnMount != null) {
            return false;
        }
        if (this.requiresRepublish != null ? !this.requiresRepublish.equals(that.requiresRepublish) : that.requiresRepublish != null) {
            return false;
        }
        if (this.seLinuxMount != null ? !this.seLinuxMount.equals(that.seLinuxMount) : that.seLinuxMount != null) {
            return false;
        }
        if (this.storageCapacity != null ? !this.storageCapacity.equals(that.storageCapacity) : that.storageCapacity != null) {
            return false;
        }
        if (this.tokenRequests != null ? !this.tokenRequests.equals(that.tokenRequests) : that.tokenRequests != null) {
            return false;
        }
        if (this.volumeLifecycleModes != null ? !this.volumeLifecycleModes.equals(that.volumeLifecycleModes) : that.volumeLifecycleModes != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.attachRequired, this.fsGroupPolicy, this.podInfoOnMount, this.requiresRepublish, this.seLinuxMount, this.storageCapacity, this.tokenRequests, this.volumeLifecycleModes, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.attachRequired != null) {
            sb.append("attachRequired:");
            sb.append(this.attachRequired + ",");
        }
        if (this.fsGroupPolicy != null) {
            sb.append("fsGroupPolicy:");
            sb.append(this.fsGroupPolicy + ",");
        }
        if (this.podInfoOnMount != null) {
            sb.append("podInfoOnMount:");
            sb.append(this.podInfoOnMount + ",");
        }
        if (this.requiresRepublish != null) {
            sb.append("requiresRepublish:");
            sb.append(this.requiresRepublish + ",");
        }
        if (this.seLinuxMount != null) {
            sb.append("seLinuxMount:");
            sb.append(this.seLinuxMount + ",");
        }
        if (this.storageCapacity != null) {
            sb.append("storageCapacity:");
            sb.append(this.storageCapacity + ",");
        }
        if (this.tokenRequests != null && !this.tokenRequests.isEmpty()) {
            sb.append("tokenRequests:");
            sb.append(this.tokenRequests + ",");
        }
        if (this.volumeLifecycleModes != null && !this.volumeLifecycleModes.isEmpty()) {
            sb.append("volumeLifecycleModes:");
            sb.append(this.volumeLifecycleModes + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withAttachRequired() {
        return this.withAttachRequired(true);
    }

    @Override
    public A withPodInfoOnMount() {
        return this.withPodInfoOnMount(true);
    }

    @Override
    public A withRequiresRepublish() {
        return this.withRequiresRepublish(true);
    }

    @Override
    public A withSeLinuxMount() {
        return this.withSeLinuxMount(true);
    }

    @Override
    public A withStorageCapacity() {
        return this.withStorageCapacity(true);
    }

    class TokenRequestsNestedImpl<N>
    extends TokenRequestFluentImpl<CSIDriverSpecFluent.TokenRequestsNested<N>>
    implements CSIDriverSpecFluent.TokenRequestsNested<N>,
    Nested<N> {
        TokenRequestBuilder builder;
        Integer index;

        TokenRequestsNestedImpl(Integer index, TokenRequest item) {
            this.index = index;
            this.builder = new TokenRequestBuilder(this, item);
        }

        TokenRequestsNestedImpl() {
            this.index = -1;
            this.builder = new TokenRequestBuilder(this);
        }

        @Override
        public N and() {
            return (N)CSIDriverSpecFluentImpl.this.setToTokenRequests(this.index, this.builder.build());
        }

        @Override
        public N endTokenRequest() {
            return this.and();
        }
    }
}

