/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.storage;

import io.fabric8.kubernetes.api.builder.v6_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_6.storage.CSINode;
import io.fabric8.kubernetes.api.model.v6_6.storage.CSINodeFluent;
import io.fabric8.kubernetes.api.model.v6_6.storage.CSINodeFluentImpl;

public class CSINodeBuilder
extends CSINodeFluentImpl<CSINodeBuilder>
implements VisitableBuilder<CSINode, CSINodeBuilder> {
    CSINodeFluent<?> fluent;
    Boolean validationEnabled;

    public CSINodeBuilder() {
        this(false);
    }

    public CSINodeBuilder(Boolean validationEnabled) {
        this(new CSINode(), validationEnabled);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CSINode(), validationEnabled);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent, CSINode instance) {
        this(fluent, instance, false);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent, CSINode instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public CSINodeBuilder(CSINode instance) {
        this(instance, (Boolean)false);
    }

    public CSINodeBuilder(CSINode instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CSINode build() {
        CSINode buildable = new CSINode(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

