/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_6.Secret;
import io.fabric8.kubernetes.api.model.v6_6.SecretFluent;
import io.fabric8.kubernetes.api.model.v6_6.SecretFluentImpl;

public class SecretBuilder
extends SecretFluentImpl<SecretBuilder>
implements VisitableBuilder<Secret, SecretBuilder> {
    SecretFluent<?> fluent;
    Boolean validationEnabled;

    public SecretBuilder() {
        this(false);
    }

    public SecretBuilder(Boolean validationEnabled) {
        this(new Secret(), validationEnabled);
    }

    public SecretBuilder(SecretFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public SecretBuilder(SecretFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Secret(), validationEnabled);
    }

    public SecretBuilder(SecretFluent<?> fluent, Secret instance) {
        this(fluent, instance, false);
    }

    public SecretBuilder(SecretFluent<?> fluent, Secret instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withData(instance.getData());
        fluent.withImmutable(instance.getImmutable());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withStringData(instance.getStringData());
        fluent.withType(instance.getType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public SecretBuilder(Secret instance) {
        this(instance, (Boolean)false);
    }

    public SecretBuilder(Secret instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withData(instance.getData());
        this.withImmutable(instance.getImmutable());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withStringData(instance.getStringData());
        this.withType(instance.getType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Secret build() {
        Secret buildable = new Secret(this.fluent.getApiVersion(), this.fluent.getData(), this.fluent.getImmutable(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getStringData(), this.fluent.getType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

