/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_6.KubernetesList;
import io.fabric8.kubernetes.api.model.v6_6.KubernetesListFluent;
import io.fabric8.kubernetes.api.model.v6_6.KubernetesListFluentImpl;

public class KubernetesListBuilder
extends KubernetesListFluentImpl<KubernetesListBuilder>
implements VisitableBuilder<KubernetesList, KubernetesListBuilder> {
    KubernetesListFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesListBuilder() {
        this(false);
    }

    public KubernetesListBuilder(Boolean validationEnabled) {
        this(new KubernetesList(), validationEnabled);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesList(), validationEnabled);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, KubernetesList instance) {
        this(fluent, instance, false);
    }

    public KubernetesListBuilder(KubernetesListFluent<?> fluent, KubernetesList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesListBuilder(KubernetesList instance) {
        this(instance, (Boolean)false);
    }

    public KubernetesListBuilder(KubernetesList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KubernetesList build() {
        KubernetesList buildable = new KubernetesList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        return buildable;
    }
}

