/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v6_6.APIResource;
import io.fabric8.kubernetes.api.model.v6_6.APIResourceFluent;
import io.fabric8.kubernetes.api.model.v6_6.APIResourceFluentImpl;

public class APIResourceBuilder
extends APIResourceFluentImpl<APIResourceBuilder>
implements VisitableBuilder<APIResource, APIResourceBuilder> {
    APIResourceFluent<?> fluent;
    Boolean validationEnabled;

    public APIResourceBuilder() {
        this(false);
    }

    public APIResourceBuilder(Boolean validationEnabled) {
        this(new APIResource(), validationEnabled);
    }

    public APIResourceBuilder(APIResourceFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public APIResourceBuilder(APIResourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new APIResource(), validationEnabled);
    }

    public APIResourceBuilder(APIResourceFluent<?> fluent, APIResource instance) {
        this(fluent, instance, false);
    }

    public APIResourceBuilder(APIResourceFluent<?> fluent, APIResource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCategories(instance.getCategories());
        fluent.withGroup(instance.getGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespaced(instance.getNamespaced());
        fluent.withShortNames(instance.getShortNames());
        fluent.withSingularName(instance.getSingularName());
        fluent.withStorageVersionHash(instance.getStorageVersionHash());
        fluent.withVerbs(instance.getVerbs());
        fluent.withVersion(instance.getVersion());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public APIResourceBuilder(APIResource instance) {
        this(instance, (Boolean)false);
    }

    public APIResourceBuilder(APIResource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCategories(instance.getCategories());
        this.withGroup(instance.getGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespaced(instance.getNamespaced());
        this.withShortNames(instance.getShortNames());
        this.withSingularName(instance.getSingularName());
        this.withStorageVersionHash(instance.getStorageVersionHash());
        this.withVerbs(instance.getVerbs());
        this.withVersion(instance.getVersion());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public APIResource build() {
        APIResource buildable = new APIResource(this.fluent.getCategories(), this.fluent.getGroup(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespaced(), this.fluent.getShortNames(), this.fluent.getSingularName(), this.fluent.getStorageVersionHash(), this.fluent.getVerbs(), this.fluent.getVersion());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }
}

