/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.Builder;
import io.fabric8.kubernetes.api.builder.v6_6.Editable;
import io.fabric8.kubernetes.api.builder.v6_6.Fluent;
import io.fabric8.kubernetes.api.builder.v6_6.Visitable;
import io.fabric8.kubernetes.api.builder.v6_6.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.v6_6.VisitableMap;
import io.fabric8.kubernetes.api.builder.v6_6.Visitor;
import io.fabric8.kubernetes.api.builder.v6_6.VisitorListener;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BaseFluent<F extends Fluent<F>>
implements Fluent<F>,
Visitable<F> {
    public static final String VISIT = "visit";
    public final VisitableMap _visitables = new VisitableMap();

    public static <T> VisitableBuilder<T, ?> builderOf(T item) {
        Object editor;
        if (item instanceof Editable && (editor = ((Editable)item).edit()) instanceof VisitableBuilder) {
            return (VisitableBuilder)editor;
        }
        try {
            return (VisitableBuilder)Class.forName(item.getClass().getName() + "Builder").getConstructor(item.getClass()).newInstance(item);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create builder for: " + item.getClass(), e);
        }
    }

    public static <T> List<T> build(List<? extends Builder<? extends T>> list) {
        return list == null ? null : list.stream().map(Builder::build).collect(Collectors.toList());
    }

    public static <T> Set<T> build(Set<? extends Builder<? extends T>> set) {
        return set == null ? null : new LinkedHashSet(set.stream().map(Builder::build).collect(Collectors.toSet()));
    }

    public static <T> List<T> aggregate(List<? extends T> ... lists) {
        return new ArrayList(Arrays.stream(lists).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    public static <T> Set<T> aggregate(Set<? extends T> ... sets) {
        return new LinkedHashSet(Arrays.stream(sets).filter(Objects::nonNull).collect(Collectors.toSet()));
    }

    @Override
    public F accept(Visitor ... visitors) {
        return (F)this.accept(Collections.emptyList(), visitors);
    }

    @Override
    public <V> F accept(final Class<V> type, final Visitor<V> visitor) {
        return (F)this.accept(Collections.emptyList(), new Visitor[]{new Visitor<V>(){

            @Override
            public Class<V> getType() {
                return type;
            }

            @Override
            public void visit(List<Map.Entry<String, Object>> path, V element) {
                visitor.visit(path, element);
            }

            @Override
            public void visit(V element) {
                visitor.visit(element);
            }
        }});
    }

    @Override
    public F accept(List<Map.Entry<String, Object>> path, Visitor ... visitors) {
        return (F)this.accept((List)path, "", visitors);
    }

    @Override
    public F accept(List<Map.Entry<String, Object>> path, String currentKey, Visitor ... visitors) {
        ArrayList sortedVisitor = new ArrayList();
        for (Visitor visitor : visitors) {
            Visitor visitor2 = VisitorListener.wrap(visitor);
            if (!visitor2.canVisit(path, this).booleanValue()) continue;
            sortedVisitor.add(visitor2);
        }
        sortedVisitor.sort((l, r) -> r.order() - l.order());
        for (Visitor visitor : sortedVisitor) {
            visitor.visit(path, this);
        }
        ArrayList<Map.Entry<String, Object>> copyOfPath = path != null ? new ArrayList<Map.Entry<String, Object>>(path) : new ArrayList();
        copyOfPath.add(new AbstractMap.SimpleEntry<String, BaseFluent>(currentKey, this));
        for (Map.Entry entry : this._visitables.entrySet()) {
            List<Map.Entry<String, Object>> list = Collections.unmodifiableList(copyOfPath);
            for (Visitable visitable : new ArrayList((List)entry.getValue())) {
                for (Visitor visitor : visitors) {
                    if (visitor.getType() == null || !visitor.getType().isAssignableFrom(visitable.getClass())) continue;
                    visitable.accept(list, (String)entry.getKey(), visitor);
                }
                for (Visitor visitor : visitors) {
                    if (visitor.getType() != null && visitor.getType().isAssignableFrom(visitable.getClass())) continue;
                    visitable.accept(list, (String)entry.getKey(), visitor);
                }
            }
        }
        return (F)this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + 0;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

