/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.WebSpec;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.WebSpecFluent;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.WebTLSConfig;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.WebTLSConfigBuilder;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.WebTLSConfigFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class WebSpecFluentImpl<A extends WebSpecFluent<A>>
extends BaseFluent<A>
implements WebSpecFluent<A> {
    private String pageTitle;
    private WebTLSConfigBuilder tlsConfig;
    private Map<String, Object> additionalProperties;

    public WebSpecFluentImpl() {
    }

    public WebSpecFluentImpl(WebSpec instance) {
        this.withPageTitle(instance.getPageTitle());
        this.withTlsConfig(instance.getTlsConfig());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getPageTitle() {
        return this.pageTitle;
    }

    @Override
    public A withPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
        return (A)this;
    }

    @Override
    public Boolean hasPageTitle() {
        return this.pageTitle != null;
    }

    @Override
    @Deprecated
    public WebTLSConfig getTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public WebTLSConfig buildTlsConfig() {
        return this.tlsConfig != null ? this.tlsConfig.build() : null;
    }

    @Override
    public A withTlsConfig(WebTLSConfig tlsConfig) {
        this._visitables.get("tlsConfig").remove(this.tlsConfig);
        if (tlsConfig != null) {
            this.tlsConfig = new WebTLSConfigBuilder(tlsConfig);
            this._visitables.get("tlsConfig").add(this.tlsConfig);
        } else {
            this.tlsConfig = null;
            this._visitables.get("tlsConfig").remove(this.tlsConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsConfig() {
        return this.tlsConfig != null;
    }

    @Override
    public WebSpecFluent.TlsConfigNested<A> withNewTlsConfig() {
        return new TlsConfigNestedImpl();
    }

    @Override
    public WebSpecFluent.TlsConfigNested<A> withNewTlsConfigLike(WebTLSConfig item) {
        return new TlsConfigNestedImpl(item);
    }

    @Override
    public WebSpecFluent.TlsConfigNested<A> editTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig());
    }

    @Override
    public WebSpecFluent.TlsConfigNested<A> editOrNewTlsConfig() {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : new WebTLSConfigBuilder().build());
    }

    @Override
    public WebSpecFluent.TlsConfigNested<A> editOrNewTlsConfigLike(WebTLSConfig item) {
        return this.withNewTlsConfigLike(this.getTlsConfig() != null ? this.getTlsConfig() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSpecFluentImpl that = (WebSpecFluentImpl)o;
        if (this.pageTitle != null ? !this.pageTitle.equals(that.pageTitle) : that.pageTitle != null) {
            return false;
        }
        if (this.tlsConfig != null ? !this.tlsConfig.equals(that.tlsConfig) : that.tlsConfig != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pageTitle, this.tlsConfig, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.pageTitle != null) {
            sb.append("pageTitle:");
            sb.append(this.pageTitle + ",");
        }
        if (this.tlsConfig != null) {
            sb.append("tlsConfig:");
            sb.append(this.tlsConfig + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class TlsConfigNestedImpl<N>
    extends WebTLSConfigFluentImpl<WebSpecFluent.TlsConfigNested<N>>
    implements WebSpecFluent.TlsConfigNested<N>,
    Nested<N> {
        WebTLSConfigBuilder builder;

        TlsConfigNestedImpl(WebTLSConfig item) {
            this.builder = new WebTLSConfigBuilder(this, item);
        }

        TlsConfigNestedImpl() {
            this.builder = new WebTLSConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)WebSpecFluentImpl.this.withTlsConfig(this.builder.build());
        }

        @Override
        public N endTlsConfig() {
            return this.and();
        }
    }
}

