/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.SecretKeySelector;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.OAuth2;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.OAuth2Fluent;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.SecretOrConfigMap;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.SecretOrConfigMapBuilder;
import io.fabric8.openshift.api.model.v6_6.monitoring.v1.SecretOrConfigMapFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OAuth2FluentImpl<A extends OAuth2Fluent<A>>
extends BaseFluent<A>
implements OAuth2Fluent<A> {
    private SecretOrConfigMapBuilder clientId;
    private SecretKeySelector clientSecret;
    private Map<String, String> endpointParams;
    private List<String> scopes = new ArrayList<String>();
    private String tokenUrl;
    private Map<String, Object> additionalProperties;

    public OAuth2FluentImpl() {
    }

    public OAuth2FluentImpl(OAuth2 instance) {
        this.withClientId(instance.getClientId());
        this.withClientSecret(instance.getClientSecret());
        this.withEndpointParams(instance.getEndpointParams());
        this.withScopes(instance.getScopes());
        this.withTokenUrl(instance.getTokenUrl());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    @Deprecated
    public SecretOrConfigMap getClientId() {
        return this.clientId != null ? this.clientId.build() : null;
    }

    @Override
    public SecretOrConfigMap buildClientId() {
        return this.clientId != null ? this.clientId.build() : null;
    }

    @Override
    public A withClientId(SecretOrConfigMap clientId) {
        this._visitables.get("clientId").remove(this.clientId);
        if (clientId != null) {
            this.clientId = new SecretOrConfigMapBuilder(clientId);
            this._visitables.get("clientId").add(this.clientId);
        } else {
            this.clientId = null;
            this._visitables.get("clientId").remove(this.clientId);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientId() {
        return this.clientId != null;
    }

    @Override
    public OAuth2Fluent.ClientIdNested<A> withNewClientId() {
        return new ClientIdNestedImpl();
    }

    @Override
    public OAuth2Fluent.ClientIdNested<A> withNewClientIdLike(SecretOrConfigMap item) {
        return new ClientIdNestedImpl(item);
    }

    @Override
    public OAuth2Fluent.ClientIdNested<A> editClientId() {
        return this.withNewClientIdLike(this.getClientId());
    }

    @Override
    public OAuth2Fluent.ClientIdNested<A> editOrNewClientId() {
        return this.withNewClientIdLike(this.getClientId() != null ? this.getClientId() : new SecretOrConfigMapBuilder().build());
    }

    @Override
    public OAuth2Fluent.ClientIdNested<A> editOrNewClientIdLike(SecretOrConfigMap item) {
        return this.withNewClientIdLike(this.getClientId() != null ? this.getClientId() : item);
    }

    @Override
    public SecretKeySelector getClientSecret() {
        return this.clientSecret;
    }

    @Override
    public A withClientSecret(SecretKeySelector clientSecret) {
        this.clientSecret = clientSecret;
        return (A)this;
    }

    @Override
    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    @Override
    public A withNewClientSecret(String key, String name, Boolean optional) {
        return this.withClientSecret(new SecretKeySelector(key, name, optional));
    }

    @Override
    public A addToEndpointParams(String key, String value) {
        if (this.endpointParams == null && key != null && value != null) {
            this.endpointParams = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.endpointParams.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToEndpointParams(Map<String, String> map) {
        if (this.endpointParams == null && map != null) {
            this.endpointParams = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.endpointParams.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpointParams(String key) {
        if (this.endpointParams == null) {
            return (A)this;
        }
        if (key != null && this.endpointParams != null) {
            this.endpointParams.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpointParams(Map<String, String> map) {
        if (this.endpointParams == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.endpointParams == null) continue;
                this.endpointParams.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getEndpointParams() {
        return this.endpointParams;
    }

    @Override
    public <K, V> A withEndpointParams(Map<String, String> endpointParams) {
        this.endpointParams = endpointParams == null ? null : new LinkedHashMap<String, String>(endpointParams);
        return (A)this;
    }

    @Override
    public Boolean hasEndpointParams() {
        return this.endpointParams != null;
    }

    @Override
    public A addToScopes(Integer index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToScopes(Integer index, String item) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        this.scopes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToScopes(String ... items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToScopes(Collection<String> items) {
        if (this.scopes == null) {
            this.scopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.scopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromScopes(String ... items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromScopes(Collection<String> items) {
        for (String item : items) {
            if (this.scopes == null) continue;
            this.scopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getScopes() {
        return this.scopes;
    }

    @Override
    public String getScope(Integer index) {
        return this.scopes.get(index);
    }

    @Override
    public String getFirstScope() {
        return this.scopes.get(0);
    }

    @Override
    public String getLastScope() {
        return this.scopes.get(this.scopes.size() - 1);
    }

    @Override
    public String getMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingScope(Predicate<String> predicate) {
        for (String item : this.scopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withScopes(List<String> scopes) {
        if (scopes != null) {
            this.scopes = new ArrayList<String>();
            for (String item : scopes) {
                this.addToScopes(item);
            }
        } else {
            this.scopes = null;
        }
        return (A)this;
    }

    @Override
    public A withScopes(String ... scopes) {
        if (this.scopes != null) {
            this.scopes.clear();
        }
        if (scopes != null) {
            for (String item : scopes) {
                this.addToScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    @Override
    public String getTokenUrl() {
        return this.tokenUrl;
    }

    @Override
    public A withTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
        return (A)this;
    }

    @Override
    public Boolean hasTokenUrl() {
        return this.tokenUrl != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OAuth2FluentImpl that = (OAuth2FluentImpl)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) {
            return false;
        }
        if (this.endpointParams != null ? !this.endpointParams.equals(that.endpointParams) : that.endpointParams != null) {
            return false;
        }
        if (this.scopes != null ? !this.scopes.equals(that.scopes) : that.scopes != null) {
            return false;
        }
        if (this.tokenUrl != null ? !this.tokenUrl.equals(that.tokenUrl) : that.tokenUrl != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clientId, this.clientSecret, this.endpointParams, this.scopes, this.tokenUrl, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clientId != null) {
            sb.append("clientId:");
            sb.append(this.clientId + ",");
        }
        if (this.clientSecret != null) {
            sb.append("clientSecret:");
            sb.append(this.clientSecret + ",");
        }
        if (this.endpointParams != null && !this.endpointParams.isEmpty()) {
            sb.append("endpointParams:");
            sb.append(this.endpointParams + ",");
        }
        if (this.scopes != null && !this.scopes.isEmpty()) {
            sb.append("scopes:");
            sb.append(this.scopes + ",");
        }
        if (this.tokenUrl != null) {
            sb.append("tokenUrl:");
            sb.append(this.tokenUrl + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClientIdNestedImpl<N>
    extends SecretOrConfigMapFluentImpl<OAuth2Fluent.ClientIdNested<N>>
    implements OAuth2Fluent.ClientIdNested<N>,
    Nested<N> {
        SecretOrConfigMapBuilder builder;

        ClientIdNestedImpl(SecretOrConfigMap item) {
            this.builder = new SecretOrConfigMapBuilder(this, item);
        }

        ClientIdNestedImpl() {
            this.builder = new SecretOrConfigMapBuilder(this);
        }

        @Override
        public N and() {
            return (N)OAuth2FluentImpl.this.withClientId(this.builder.build());
        }

        @Override
        public N endClientId() {
            return this.and();
        }
    }
}

