/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.rbac;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.ObjectMeta;
import io.fabric8.kubernetes.api.model.v6_6.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v6_6.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.rbac.RoleBinding;
import io.fabric8.kubernetes.api.model.v6_6.rbac.RoleBindingFluent;
import io.fabric8.kubernetes.api.model.v6_6.rbac.RoleRef;
import io.fabric8.kubernetes.api.model.v6_6.rbac.RoleRefBuilder;
import io.fabric8.kubernetes.api.model.v6_6.rbac.RoleRefFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.rbac.Subject;
import io.fabric8.kubernetes.api.model.v6_6.rbac.SubjectBuilder;
import io.fabric8.kubernetes.api.model.v6_6.rbac.SubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class RoleBindingFluentImpl<A extends RoleBindingFluent<A>>
extends BaseFluent<A>
implements RoleBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private RoleRefBuilder roleRef;
    private ArrayList<SubjectBuilder> subjects = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RoleBindingFluentImpl() {
    }

    public RoleBindingFluentImpl(RoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get("metadata").remove(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public RoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public RoleRef getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public RoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(RoleRef roleRef) {
        this._visitables.get("roleRef").remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new RoleRefBuilder(roleRef);
            this._visitables.get("roleRef").add(this.roleRef);
        } else {
            this.roleRef = null;
            this._visitables.get("roleRef").remove(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public A withNewRoleRef(String apiGroup, String kind, String name) {
        return this.withRoleRef(new RoleRef(apiGroup, kind, name));
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(RoleRef item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new RoleRefBuilder().build());
    }

    @Override
    public RoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(RoleRef item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        this._visitables.get("subjects").add(index >= 0 ? index.intValue() : this._visitables.get("subjects").size(), builder);
        this.subjects.add(index >= 0 ? index.intValue() : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(Integer index, Subject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        SubjectBuilder builder = new SubjectBuilder(item);
        if (index < 0 || index >= this._visitables.get("subjects").size()) {
            this._visitables.get("subjects").add(builder);
        } else {
            this._visitables.get("subjects").set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(Subject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<Subject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList();
        }
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(Subject ... items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<Subject> items) {
        for (Subject item : items) {
            SubjectBuilder builder = new SubjectBuilder(item);
            this._visitables.get("subjects").remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSubjects(Predicate<SubjectBuilder> predicate) {
        if (this.subjects == null) {
            return (A)this;
        }
        Iterator<SubjectBuilder> each = this.subjects.iterator();
        Object visitables = this._visitables.get("subjects");
        while (each.hasNext()) {
            SubjectBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Subject> getSubjects() {
        return this.subjects != null ? RoleBindingFluentImpl.build(this.subjects) : null;
    }

    @Override
    public List<Subject> buildSubjects() {
        return this.subjects != null ? RoleBindingFluentImpl.build(this.subjects) : null;
    }

    @Override
    public Subject buildSubject(Integer index) {
        return this.subjects.get(index).build();
    }

    @Override
    public Subject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public Subject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public Subject buildMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSubject(Predicate<SubjectBuilder> predicate) {
        for (SubjectBuilder item : this.subjects) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSubjects(List<Subject> subjects) {
        if (this.subjects != null) {
            this._visitables.get("subjects").removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList();
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = null;
        }
        return (A)this;
    }

    @Override
    public A withSubjects(Subject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (Subject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public A addNewSubject(String apiGroup, String kind, String name, String namespace) {
        return this.addToSubjects(new Subject(apiGroup, kind, name, namespace));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> addNewSubjectLike(Subject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> setNewSubjectLike(Integer index, Subject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editSubject(Integer index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public RoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<SubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.test(this.subjects.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoleBindingFluentImpl that = (RoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        if (this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.roleRef, this.subjects, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata + ",");
        }
        if (this.roleRef != null) {
            sb.append("roleRef:");
            sb.append(this.roleRef + ",");
        }
        if (this.subjects != null && !this.subjects.isEmpty()) {
            sb.append("subjects:");
            sb.append(this.subjects + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class SubjectsNestedImpl<N>
    extends SubjectFluentImpl<RoleBindingFluent.SubjectsNested<N>>
    implements RoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        SubjectBuilder builder;
        Integer index;

        SubjectsNestedImpl(Integer index, Subject item) {
            this.index = index;
            this.builder = new SubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new SubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    class RoleRefNestedImpl<N>
    extends RoleRefFluentImpl<RoleBindingFluent.RoleRefNested<N>>
    implements RoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        RoleRefBuilder builder;

        RoleRefNestedImpl(RoleRef item) {
            this.builder = new RoleRefBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new RoleRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<RoleBindingFluent.MetadataNested<N>>
    implements RoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)RoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

