/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.model.v6_6.Quantity;
import io.fabric8.kubernetes.api.model.v6_6.autoscaling.v2.MetricValueStatus;
import io.fabric8.kubernetes.api.model.v6_6.autoscaling.v2.MetricValueStatusFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MetricValueStatusFluentImpl<A extends MetricValueStatusFluent<A>>
extends BaseFluent<A>
implements MetricValueStatusFluent<A> {
    private Integer averageUtilization;
    private Quantity averageValue;
    private Quantity value;
    private Map<String, Object> additionalProperties;

    public MetricValueStatusFluentImpl() {
    }

    public MetricValueStatusFluentImpl(MetricValueStatus instance) {
        this.withAverageUtilization(instance.getAverageUtilization());
        this.withAverageValue(instance.getAverageValue());
        this.withValue(instance.getValue());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getAverageUtilization() {
        return this.averageUtilization;
    }

    @Override
    public A withAverageUtilization(Integer averageUtilization) {
        this.averageUtilization = averageUtilization;
        return (A)this;
    }

    @Override
    public Boolean hasAverageUtilization() {
        return this.averageUtilization != null;
    }

    @Override
    public Quantity getAverageValue() {
        return this.averageValue;
    }

    @Override
    public A withAverageValue(Quantity averageValue) {
        this.averageValue = averageValue;
        return (A)this;
    }

    @Override
    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    @Override
    public A withNewAverageValue(String amount, String format) {
        return this.withAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewAverageValue(String amount) {
        return this.withAverageValue(new Quantity(amount));
    }

    @Override
    public Quantity getValue() {
        return this.value;
    }

    @Override
    public A withValue(Quantity value) {
        this.value = value;
        return (A)this;
    }

    @Override
    public Boolean hasValue() {
        return this.value != null;
    }

    @Override
    public A withNewValue(String amount, String format) {
        return this.withValue(new Quantity(amount, format));
    }

    @Override
    public A withNewValue(String amount) {
        return this.withValue(new Quantity(amount));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricValueStatusFluentImpl that = (MetricValueStatusFluentImpl)o;
        if (this.averageUtilization != null ? !this.averageUtilization.equals(that.averageUtilization) : that.averageUtilization != null) {
            return false;
        }
        if (this.averageValue != null ? !this.averageValue.equals(that.averageValue) : that.averageValue != null) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.averageUtilization, this.averageValue, this.value, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.averageUtilization != null) {
            sb.append("averageUtilization:");
            sb.append(this.averageUtilization + ",");
        }
        if (this.averageValue != null) {
            sb.append("averageValue:");
            sb.append(this.averageValue + ",");
        }
        if (this.value != null) {
            sb.append("value:");
            sb.append(this.value + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

