/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v6_6;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.APIGroup;
import io.fabric8.kubernetes.api.model.v6_6.APIGroupBuilder;
import io.fabric8.kubernetes.api.model.v6_6.APIGroupFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.APIGroupList;
import io.fabric8.kubernetes.api.model.v6_6.APIGroupListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class APIGroupListFluentImpl<A extends APIGroupListFluent<A>>
extends BaseFluent<A>
implements APIGroupListFluent<A> {
    private String apiVersion;
    private ArrayList<APIGroupBuilder> groups = new ArrayList();
    private String kind;
    private Map<String, Object> additionalProperties;

    public APIGroupListFluentImpl() {
    }

    public APIGroupListFluentImpl(APIGroupList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withGroups(instance.getGroups());
        this.withKind(instance.getKind());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToGroups(Integer index, APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        APIGroupBuilder builder = new APIGroupBuilder(item);
        this._visitables.get("groups").add(index >= 0 ? index.intValue() : this._visitables.get("groups").size(), builder);
        this.groups.add(index >= 0 ? index.intValue() : this.groups.size(), builder);
        return (A)this;
    }

    @Override
    public A setToGroups(Integer index, APIGroup item) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        APIGroupBuilder builder = new APIGroupBuilder(item);
        if (index < 0 || index >= this._visitables.get("groups").size()) {
            this._visitables.get("groups").add(builder);
        } else {
            this._visitables.get("groups").set(index, builder);
        }
        if (index < 0 || index >= this.groups.size()) {
            this.groups.add(builder);
        } else {
            this.groups.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToGroups(APIGroup ... items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToGroups(Collection<APIGroup> items) {
        if (this.groups == null) {
            this.groups = new ArrayList();
        }
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").add(builder);
            this.groups.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromGroups(APIGroup ... items) {
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            if (this.groups == null) continue;
            this.groups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGroups(Collection<APIGroup> items) {
        for (APIGroup item : items) {
            APIGroupBuilder builder = new APIGroupBuilder(item);
            this._visitables.get("groups").remove(builder);
            if (this.groups == null) continue;
            this.groups.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromGroups(Predicate<APIGroupBuilder> predicate) {
        if (this.groups == null) {
            return (A)this;
        }
        Iterator<APIGroupBuilder> each = this.groups.iterator();
        Object visitables = this._visitables.get("groups");
        while (each.hasNext()) {
            APIGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<APIGroup> getGroups() {
        return this.groups != null ? APIGroupListFluentImpl.build(this.groups) : null;
    }

    @Override
    public List<APIGroup> buildGroups() {
        return this.groups != null ? APIGroupListFluentImpl.build(this.groups) : null;
    }

    @Override
    public APIGroup buildGroup(Integer index) {
        return this.groups.get(index).build();
    }

    @Override
    public APIGroup buildFirstGroup() {
        return this.groups.get(0).build();
    }

    @Override
    public APIGroup buildLastGroup() {
        return this.groups.get(this.groups.size() - 1).build();
    }

    @Override
    public APIGroup buildMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        for (APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        for (APIGroupBuilder item : this.groups) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGroups(List<APIGroup> groups) {
        if (this.groups != null) {
            this._visitables.get("groups").removeAll(this.groups);
        }
        if (groups != null) {
            this.groups = new ArrayList();
            for (APIGroup item : groups) {
                this.addToGroups(item);
            }
        } else {
            this.groups = null;
        }
        return (A)this;
    }

    @Override
    public A withGroups(APIGroup ... groups) {
        if (this.groups != null) {
            this.groups.clear();
        }
        if (groups != null) {
            for (APIGroup item : groups) {
                this.addToGroups(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    @Override
    public APIGroupListFluent.GroupsNested<A> addNewGroup() {
        return new GroupsNestedImpl();
    }

    @Override
    public APIGroupListFluent.GroupsNested<A> addNewGroupLike(APIGroup item) {
        return new GroupsNestedImpl(-1, item);
    }

    @Override
    public APIGroupListFluent.GroupsNested<A> setNewGroupLike(Integer index, APIGroup item) {
        return new GroupsNestedImpl(index, item);
    }

    @Override
    public APIGroupListFluent.GroupsNested<A> editGroup(Integer index) {
        if (this.groups.size() <= index) {
            throw new RuntimeException("Can't edit groups. Index exceeds size.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public APIGroupListFluent.GroupsNested<A> editFirstGroup() {
        if (this.groups.size() == 0) {
            throw new RuntimeException("Can't edit first groups. The list is empty.");
        }
        return this.setNewGroupLike(0, this.buildGroup(0));
    }

    @Override
    public APIGroupListFluent.GroupsNested<A> editLastGroup() {
        int index = this.groups.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last groups. The list is empty.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public APIGroupListFluent.GroupsNested<A> editMatchingGroup(Predicate<APIGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!predicate.test(this.groups.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching groups. No match found.");
        }
        return this.setNewGroupLike(index, this.buildGroup(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        APIGroupListFluentImpl that = (APIGroupListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.apiVersion, this.groups, this.kind, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            sb.append("groups:");
            sb.append(this.groups + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class GroupsNestedImpl<N>
    extends APIGroupFluentImpl<APIGroupListFluent.GroupsNested<N>>
    implements APIGroupListFluent.GroupsNested<N>,
    Nested<N> {
        APIGroupBuilder builder;
        Integer index;

        GroupsNestedImpl(Integer index, APIGroup item) {
            this.index = index;
            this.builder = new APIGroupBuilder(this, item);
        }

        GroupsNestedImpl() {
            this.index = -1;
            this.builder = new APIGroupBuilder(this);
        }

        @Override
        public N and() {
            return (N)APIGroupListFluentImpl.this.setToGroups(this.index, this.builder.build());
        }

        @Override
        public N endGroup() {
            return this.and();
        }
    }
}

