/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v6_6.dsl.internal.core;

import com.fasterxml.jackson.core.type.TypeReference;
import com.mifmif.common.regex.Generex;
import io.fabric8.kubernetes.api.model.v6_6.KubernetesList;
import io.fabric8.kubernetes.api.model.v6_6.KubernetesListBuilder;
import io.fabric8.kubernetes.clnt.v6_6.Client;
import io.fabric8.kubernetes.clnt.v6_6.KubernetesClient;
import io.fabric8.kubernetes.clnt.v6_6.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v6_6.OperationInfo;
import io.fabric8.kubernetes.clnt.v6_6.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v6_6.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v6_6.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.clnt.v6_6.dsl.internal.OperationContext;
import io.fabric8.kubernetes.clnt.v6_6.http.HttpRequest;
import io.fabric8.kubernetes.clnt.v6_6.utils.Serialization;
import io.fabric8.kubernetes.clnt.v6_6.utils.Utils;
import io.fabric8.openshift.api.model.v6_6.Parameter;
import io.fabric8.openshift.api.model.v6_6.Template;
import io.fabric8.openshift.api.model.v6_6.TemplateBuilder;
import io.fabric8.openshift.api.model.v6_6.TemplateFluent;
import io.fabric8.openshift.api.model.v6_6.TemplateList;
import io.fabric8.openshift.clnt.v6_6.ParameterValue;
import io.fabric8.openshift.clnt.v6_6.dsl.TemplateResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateOperationsImpl
extends HasMetadataOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>>
implements TemplateResource<Template, KubernetesList>,
ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> {
    private static final Logger logger = LoggerFactory.getLogger(TemplateOperationsImpl.class);
    private static final String EXPRESSION = "expression";
    private static final TypeReference<HashMap<String, String>> MAPS_REFERENCE = new TypeReference<HashMap<String, String>>(){};
    private final Map<String, String> parameters;

    public TemplateOperationsImpl(Client client) {
        this(HasMetadataOperationsImpl.defaultContext(client), null);
    }

    public TemplateOperationsImpl(OperationContext context, Map<String, String> parameters) {
        super(context.withApiGroupName("template.openshift.io").withPlural("templates"), Template.class, TemplateList.class);
        this.parameters = parameters;
    }

    @Override
    public TemplateOperationsImpl newInstance(OperationContext context) {
        return new TemplateOperationsImpl(context, this.parameters);
    }

    public TemplateOperationsImpl newInstance(OperationContext context, Map<String, String> parameters) {
        return new TemplateOperationsImpl(context, (Map<String, String>)(parameters == null ? null : new LinkedHashMap<String, String>(parameters)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KubernetesList process(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.process(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("process"), (Throwable)e);
        }
    }

    public KubernetesList process(InputStream is) {
        return this.process(TemplateOperationsImpl.unmarshal(is, MAPS_REFERENCE));
    }

    public KubernetesList process(Map<String, String> valuesMap) {
        Template t = this.get();
        try {
            List<Parameter> parameters = t.getParameters();
            if (parameters != null) {
                for (Parameter p : parameters) {
                    String v = valuesMap.get(p.getName());
                    if (v == null) continue;
                    p.setGenerate(null);
                    p.setValue(v);
                }
            }
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", JSON_MAPPER.writeValueAsString((Object)t)).url(this.getProcessUrl());
            t = (Template)this.handleResponse(requestBuilder);
            KubernetesList l = new KubernetesList();
            l.setItems(t.getObjects());
            return l;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("process"), (Throwable)e);
        }
    }

    public KubernetesList process(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.process(valuesMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public KubernetesList processLocally(File f) {
        try (FileInputStream is = new FileInputStream(f);){
            KubernetesList kubernetesList = this.processLocally(is);
            return kubernetesList;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable((OperationInfo)this.forOperationType("processLocally"), (Throwable)e);
        }
    }

    public KubernetesList processLocally(InputStream is) {
        return this.processLocally(TemplateOperationsImpl.unmarshal(is, MAPS_REFERENCE));
    }

    public KubernetesList processLocally(ParameterValue ... values) {
        HashMap<String, String> valuesMap = new HashMap<String, String>(values.length);
        for (ParameterValue pv : values) {
            valuesMap.put(pv.getName(), pv.getValue());
        }
        return this.processLocally(valuesMap);
    }

    public TemplateOperationsImpl withParameters(Map<String, String> parameters) {
        return this.newInstance(this.context, parameters);
    }

    public KubernetesList processLocally(Map<String, String> valuesMap) {
        Template t = this.processParameters((Template)this.getItemOrRequireFromServer());
        List<Parameter> parameters = t.getParameters();
        KubernetesList list = ((KubernetesListBuilder)new KubernetesListBuilder().withItems(t.getObjects())).build();
        String json = Serialization.asJson((Object)list);
        String last = null;
        if (parameters != null && !parameters.isEmpty()) {
            while (!Objects.equals(last, json)) {
                last = json;
                for (Parameter parameter : parameters) {
                    String parameterValue;
                    String parameterName = parameter.getName();
                    if (valuesMap.containsKey(parameterName)) {
                        parameterValue = valuesMap.get(parameterName);
                    } else if (Utils.isNotNullOrEmpty((String)parameter.getValue())) {
                        parameterValue = parameter.getValue();
                    } else if (EXPRESSION.equals(parameter.getGenerate())) {
                        Generex generex = new Generex(parameter.getFrom());
                        parameterValue = generex.random();
                    } else if (parameter.getRequired() == null || !parameter.getRequired().booleanValue()) {
                        parameterValue = "";
                    } else {
                        throw new IllegalArgumentException("No value available for parameter name: " + parameterName);
                    }
                    if (parameterValue == null) {
                        logger.debug("Parameter {} has a null value", (Object)parameterName);
                        parameterValue = "";
                    }
                    json = Utils.interpolateString((String)json, Collections.singletonMap(parameterName, parameterValue));
                }
            }
        }
        return (KubernetesList)Serialization.unmarshal((String)json, KubernetesList.class);
    }

    private URL getProcessUrl() throws MalformedURLException {
        return this.getNamespacedUrl(this.getNamespace(), "processedtemplates");
    }

    @Override
    public Template get() {
        return this.processParameters((Template)super.get());
    }

    private Template processParameters(Template t) {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            return (Template)Serialization.unmarshal((String)Utils.interpolateString((String)Serialization.asJson((Object)t), this.parameters), Template.class);
        }
        return t;
    }

    @Override
    public TemplateResource<Template, KubernetesList> load(InputStream is) {
        List items;
        Template template = null;
        List item = items = ((KubernetesClient)this.context.getClient().adapt(KubernetesClient.class)).load(is).items();
        if (items.size() == 1) {
            item = items.get(0);
        }
        if (item instanceof Template) {
            template = (Template)((Object)item);
        } else {
            String generatedName = "template-" + Utils.randomString((int)5);
            template = ((TemplateBuilder)((TemplateBuilder)((TemplateFluent.MetadataNested)new TemplateBuilder().withNewMetadata().withName(generatedName)).endMetadata()).withObjects(items)).build();
        }
        return (TemplateResource)this.resource(template);
    }
}

