/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.openshift.api.model.v6_6.operator.v1.ProjectAccess;
import io.fabric8.openshift.api.model.v6_6.operator.v1.ProjectAccessFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ProjectAccessFluentImpl<A extends ProjectAccessFluent<A>>
extends BaseFluent<A>
implements ProjectAccessFluent<A> {
    private List<String> availableClusterRoles = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public ProjectAccessFluentImpl() {
    }

    public ProjectAccessFluentImpl(ProjectAccess instance) {
        this.withAvailableClusterRoles(instance.getAvailableClusterRoles());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToAvailableClusterRoles(Integer index, String item) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        this.availableClusterRoles.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAvailableClusterRoles(Integer index, String item) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        this.availableClusterRoles.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAvailableClusterRoles(String ... items) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.availableClusterRoles.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAvailableClusterRoles(Collection<String> items) {
        if (this.availableClusterRoles == null) {
            this.availableClusterRoles = new ArrayList<String>();
        }
        for (String item : items) {
            this.availableClusterRoles.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAvailableClusterRoles(String ... items) {
        for (String item : items) {
            if (this.availableClusterRoles == null) continue;
            this.availableClusterRoles.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAvailableClusterRoles(Collection<String> items) {
        for (String item : items) {
            if (this.availableClusterRoles == null) continue;
            this.availableClusterRoles.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAvailableClusterRoles() {
        return this.availableClusterRoles;
    }

    @Override
    public String getAvailableClusterRole(Integer index) {
        return this.availableClusterRoles.get(index);
    }

    @Override
    public String getFirstAvailableClusterRole() {
        return this.availableClusterRoles.get(0);
    }

    @Override
    public String getLastAvailableClusterRole() {
        return this.availableClusterRoles.get(this.availableClusterRoles.size() - 1);
    }

    @Override
    public String getMatchingAvailableClusterRole(Predicate<String> predicate) {
        for (String item : this.availableClusterRoles) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAvailableClusterRole(Predicate<String> predicate) {
        for (String item : this.availableClusterRoles) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAvailableClusterRoles(List<String> availableClusterRoles) {
        if (availableClusterRoles != null) {
            this.availableClusterRoles = new ArrayList<String>();
            for (String item : availableClusterRoles) {
                this.addToAvailableClusterRoles(item);
            }
        } else {
            this.availableClusterRoles = null;
        }
        return (A)this;
    }

    @Override
    public A withAvailableClusterRoles(String ... availableClusterRoles) {
        if (this.availableClusterRoles != null) {
            this.availableClusterRoles.clear();
        }
        if (availableClusterRoles != null) {
            for (String item : availableClusterRoles) {
                this.addToAvailableClusterRoles(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAvailableClusterRoles() {
        return this.availableClusterRoles != null && !this.availableClusterRoles.isEmpty();
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectAccessFluentImpl that = (ProjectAccessFluentImpl)o;
        if (this.availableClusterRoles != null ? !this.availableClusterRoles.equals(that.availableClusterRoles) : that.availableClusterRoles != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.availableClusterRoles, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.availableClusterRoles != null && !this.availableClusterRoles.isEmpty()) {
            sb.append("availableClusterRoles:");
            sb.append(this.availableClusterRoles + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

