/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.operator.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.kubernetes.api.model.v6_6.Affinity;
import io.fabric8.kubernetes.api.model.v6_6.Duration;
import io.fabric8.kubernetes.api.model.v6_6.ResourceRequirements;
import io.fabric8.kubernetes.api.model.v6_6.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.v6_6.ResourceRequirementsFluentImpl;
import io.fabric8.kubernetes.api.model.v6_6.Toleration;
import io.fabric8.openshift.api.model.v6_6.operator.v1.ImagePrunerSpec;
import io.fabric8.openshift.api.model.v6_6.operator.v1.ImagePrunerSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class ImagePrunerSpecFluentImpl<A extends ImagePrunerSpecFluent<A>>
extends BaseFluent<A>
implements ImagePrunerSpecFluent<A> {
    private Affinity affinity;
    private Integer failedJobsHistoryLimit;
    private Boolean ignoreInvalidImageReferences;
    private Integer keepTagRevisions;
    private Long keepYoungerThan;
    private Duration keepYoungerThanDuration;
    private String logLevel;
    private Map<String, String> nodeSelector;
    private ResourceRequirementsBuilder resources;
    private String schedule;
    private Integer successfulJobsHistoryLimit;
    private Boolean suspend;
    private List<Toleration> tolerations = new ArrayList<Toleration>();
    private Map<String, Object> additionalProperties;

    public ImagePrunerSpecFluentImpl() {
    }

    public ImagePrunerSpecFluentImpl(ImagePrunerSpec instance) {
        this.withAffinity(instance.getAffinity());
        this.withFailedJobsHistoryLimit(instance.getFailedJobsHistoryLimit());
        this.withIgnoreInvalidImageReferences(instance.getIgnoreInvalidImageReferences());
        this.withKeepTagRevisions(instance.getKeepTagRevisions());
        this.withKeepYoungerThan(instance.getKeepYoungerThan());
        this.withKeepYoungerThanDuration(instance.getKeepYoungerThanDuration());
        this.withLogLevel(instance.getLogLevel());
        this.withNodeSelector(instance.getNodeSelector());
        this.withResources(instance.getResources());
        this.withSchedule(instance.getSchedule());
        this.withSuccessfulJobsHistoryLimit(instance.getSuccessfulJobsHistoryLimit());
        this.withSuspend(instance.getSuspend());
        this.withTolerations(instance.getTolerations());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Affinity getAffinity() {
        return this.affinity;
    }

    @Override
    public A withAffinity(Affinity affinity) {
        this.affinity = affinity;
        return (A)this;
    }

    @Override
    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    @Override
    public Integer getFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit;
    }

    @Override
    public A withFailedJobsHistoryLimit(Integer failedJobsHistoryLimit) {
        this.failedJobsHistoryLimit = failedJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasFailedJobsHistoryLimit() {
        return this.failedJobsHistoryLimit != null;
    }

    @Override
    public Boolean getIgnoreInvalidImageReferences() {
        return this.ignoreInvalidImageReferences;
    }

    @Override
    public A withIgnoreInvalidImageReferences(Boolean ignoreInvalidImageReferences) {
        this.ignoreInvalidImageReferences = ignoreInvalidImageReferences;
        return (A)this;
    }

    @Override
    public Boolean hasIgnoreInvalidImageReferences() {
        return this.ignoreInvalidImageReferences != null;
    }

    @Override
    public Integer getKeepTagRevisions() {
        return this.keepTagRevisions;
    }

    @Override
    public A withKeepTagRevisions(Integer keepTagRevisions) {
        this.keepTagRevisions = keepTagRevisions;
        return (A)this;
    }

    @Override
    public Boolean hasKeepTagRevisions() {
        return this.keepTagRevisions != null;
    }

    @Override
    public Long getKeepYoungerThan() {
        return this.keepYoungerThan;
    }

    @Override
    public A withKeepYoungerThan(Long keepYoungerThan) {
        this.keepYoungerThan = keepYoungerThan;
        return (A)this;
    }

    @Override
    public Boolean hasKeepYoungerThan() {
        return this.keepYoungerThan != null;
    }

    @Override
    public Duration getKeepYoungerThanDuration() {
        return this.keepYoungerThanDuration;
    }

    @Override
    public A withKeepYoungerThanDuration(Duration keepYoungerThanDuration) {
        this.keepYoungerThanDuration = keepYoungerThanDuration;
        return (A)this;
    }

    @Override
    public Boolean hasKeepYoungerThanDuration() {
        return this.keepYoungerThanDuration != null;
    }

    @Override
    public String getLogLevel() {
        return this.logLevel;
    }

    @Override
    public A withLogLevel(String logLevel) {
        this.logLevel = logLevel;
        return (A)this;
    }

    @Override
    public Boolean hasLogLevel() {
        return this.logLevel != null;
    }

    @Override
    public A addToNodeSelector(String key, String value) {
        if (this.nodeSelector == null && key != null && value != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.nodeSelector.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null && map != null) {
            this.nodeSelector = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.nodeSelector.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(String key) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (key != null && this.nodeSelector != null) {
            this.nodeSelector.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromNodeSelector(Map<String, String> map) {
        if (this.nodeSelector == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.nodeSelector == null) continue;
                this.nodeSelector.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    @Override
    public <K, V> A withNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector == null ? null : new LinkedHashMap<String, String>(nodeSelector);
        return (A)this;
    }

    @Override
    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    @Override
    @Deprecated
    public ResourceRequirements getResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public ResourceRequirements buildResources() {
        return this.resources != null ? this.resources.build() : null;
    }

    @Override
    public A withResources(ResourceRequirements resources) {
        this._visitables.get("resources").remove(this.resources);
        if (resources != null) {
            this.resources = new ResourceRequirementsBuilder(resources);
            this._visitables.get("resources").add(this.resources);
        } else {
            this.resources = null;
            this._visitables.get("resources").remove(this.resources);
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null;
    }

    @Override
    public ImagePrunerSpecFluent.ResourcesNested<A> withNewResources() {
        return new ResourcesNestedImpl();
    }

    @Override
    public ImagePrunerSpecFluent.ResourcesNested<A> withNewResourcesLike(ResourceRequirements item) {
        return new ResourcesNestedImpl(item);
    }

    @Override
    public ImagePrunerSpecFluent.ResourcesNested<A> editResources() {
        return this.withNewResourcesLike(this.getResources());
    }

    @Override
    public ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResources() {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : new ResourceRequirementsBuilder().build());
    }

    @Override
    public ImagePrunerSpecFluent.ResourcesNested<A> editOrNewResourcesLike(ResourceRequirements item) {
        return this.withNewResourcesLike(this.getResources() != null ? this.getResources() : item);
    }

    @Override
    public String getSchedule() {
        return this.schedule;
    }

    @Override
    public A withSchedule(String schedule) {
        this.schedule = schedule;
        return (A)this;
    }

    @Override
    public Boolean hasSchedule() {
        return this.schedule != null;
    }

    @Override
    public Integer getSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit;
    }

    @Override
    public A withSuccessfulJobsHistoryLimit(Integer successfulJobsHistoryLimit) {
        this.successfulJobsHistoryLimit = successfulJobsHistoryLimit;
        return (A)this;
    }

    @Override
    public Boolean hasSuccessfulJobsHistoryLimit() {
        return this.successfulJobsHistoryLimit != null;
    }

    @Override
    public Boolean getSuspend() {
        return this.suspend;
    }

    @Override
    public A withSuspend(Boolean suspend) {
        this.suspend = suspend;
        return (A)this;
    }

    @Override
    public Boolean hasSuspend() {
        return this.suspend != null;
    }

    @Override
    public A addToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.add(index, item);
        return (A)this;
    }

    @Override
    public A setToTolerations(Integer index, Toleration item) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        this.tolerations.set(index, item);
        return (A)this;
    }

    @Override
    public A addToTolerations(Toleration ... items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<Toleration>();
        }
        for (Toleration item : items) {
            this.tolerations.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromTolerations(Toleration ... items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {
            if (this.tolerations == null) continue;
            this.tolerations.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    @Override
    public Toleration getToleration(Integer index) {
        return this.tolerations.get(index);
    }

    @Override
    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    @Override
    public Toleration getLastToleration() {
        return this.tolerations.get(this.tolerations.size() - 1);
    }

    @Override
    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item : this.tolerations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTolerations(List<Toleration> tolerations) {
        if (tolerations != null) {
            this.tolerations = new ArrayList<Toleration>();
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        } else {
            this.tolerations = null;
        }
        return (A)this;
    }

    @Override
    public A withTolerations(Toleration ... tolerations) {
        if (this.tolerations != null) {
            this.tolerations.clear();
        }
        if (tolerations != null) {
            for (Toleration item : tolerations) {
                this.addToTolerations(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTolerations() {
        return this.tolerations != null && !this.tolerations.isEmpty();
    }

    @Override
    public A addNewToleration(String effect, String key, String operator, Long tolerationSeconds, String value) {
        return this.addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImagePrunerSpecFluentImpl that = (ImagePrunerSpecFluentImpl)o;
        if (this.affinity != null ? !this.affinity.equals(that.affinity) : that.affinity != null) {
            return false;
        }
        if (this.failedJobsHistoryLimit != null ? !this.failedJobsHistoryLimit.equals(that.failedJobsHistoryLimit) : that.failedJobsHistoryLimit != null) {
            return false;
        }
        if (this.ignoreInvalidImageReferences != null ? !this.ignoreInvalidImageReferences.equals(that.ignoreInvalidImageReferences) : that.ignoreInvalidImageReferences != null) {
            return false;
        }
        if (this.keepTagRevisions != null ? !this.keepTagRevisions.equals(that.keepTagRevisions) : that.keepTagRevisions != null) {
            return false;
        }
        if (this.keepYoungerThan != null ? !this.keepYoungerThan.equals(that.keepYoungerThan) : that.keepYoungerThan != null) {
            return false;
        }
        if (this.keepYoungerThanDuration != null ? !this.keepYoungerThanDuration.equals(that.keepYoungerThanDuration) : that.keepYoungerThanDuration != null) {
            return false;
        }
        if (this.logLevel != null ? !this.logLevel.equals(that.logLevel) : that.logLevel != null) {
            return false;
        }
        if (this.nodeSelector != null ? !this.nodeSelector.equals(that.nodeSelector) : that.nodeSelector != null) {
            return false;
        }
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        if (this.schedule != null ? !this.schedule.equals(that.schedule) : that.schedule != null) {
            return false;
        }
        if (this.successfulJobsHistoryLimit != null ? !this.successfulJobsHistoryLimit.equals(that.successfulJobsHistoryLimit) : that.successfulJobsHistoryLimit != null) {
            return false;
        }
        if (this.suspend != null ? !this.suspend.equals(that.suspend) : that.suspend != null) {
            return false;
        }
        if (this.tolerations != null ? !this.tolerations.equals(that.tolerations) : that.tolerations != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.affinity, this.failedJobsHistoryLimit, this.ignoreInvalidImageReferences, this.keepTagRevisions, this.keepYoungerThan, this.keepYoungerThanDuration, this.logLevel, this.nodeSelector, this.resources, this.schedule, this.successfulJobsHistoryLimit, this.suspend, this.tolerations, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.affinity != null) {
            sb.append("affinity:");
            sb.append(this.affinity + ",");
        }
        if (this.failedJobsHistoryLimit != null) {
            sb.append("failedJobsHistoryLimit:");
            sb.append(this.failedJobsHistoryLimit + ",");
        }
        if (this.ignoreInvalidImageReferences != null) {
            sb.append("ignoreInvalidImageReferences:");
            sb.append(this.ignoreInvalidImageReferences + ",");
        }
        if (this.keepTagRevisions != null) {
            sb.append("keepTagRevisions:");
            sb.append(this.keepTagRevisions + ",");
        }
        if (this.keepYoungerThan != null) {
            sb.append("keepYoungerThan:");
            sb.append(this.keepYoungerThan + ",");
        }
        if (this.keepYoungerThanDuration != null) {
            sb.append("keepYoungerThanDuration:");
            sb.append(this.keepYoungerThanDuration + ",");
        }
        if (this.logLevel != null) {
            sb.append("logLevel:");
            sb.append(this.logLevel + ",");
        }
        if (this.nodeSelector != null && !this.nodeSelector.isEmpty()) {
            sb.append("nodeSelector:");
            sb.append(this.nodeSelector + ",");
        }
        if (this.resources != null) {
            sb.append("resources:");
            sb.append(this.resources + ",");
        }
        if (this.schedule != null) {
            sb.append("schedule:");
            sb.append(this.schedule + ",");
        }
        if (this.successfulJobsHistoryLimit != null) {
            sb.append("successfulJobsHistoryLimit:");
            sb.append(this.successfulJobsHistoryLimit + ",");
        }
        if (this.suspend != null) {
            sb.append("suspend:");
            sb.append(this.suspend + ",");
        }
        if (this.tolerations != null && !this.tolerations.isEmpty()) {
            sb.append("tolerations:");
            sb.append(this.tolerations + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public A withIgnoreInvalidImageReferences() {
        return this.withIgnoreInvalidImageReferences(true);
    }

    @Override
    public A withSuspend() {
        return this.withSuspend(true);
    }

    class ResourcesNestedImpl<N>
    extends ResourceRequirementsFluentImpl<ImagePrunerSpecFluent.ResourcesNested<N>>
    implements ImagePrunerSpecFluent.ResourcesNested<N>,
    Nested<N> {
        ResourceRequirementsBuilder builder;

        ResourcesNestedImpl(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.builder = new ResourceRequirementsBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImagePrunerSpecFluentImpl.this.withResources(this.builder.build());
        }

        @Override
        public N endResources() {
            return this.and();
        }
    }
}

