/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.installer.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.openshift.api.model.v6_6.installer.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_6.installer.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_6.installer.v1.MachinePoolPlatform;
import io.fabric8.openshift.api.model.v6_6.installer.v1.MachinePoolPlatformBuilder;
import io.fabric8.openshift.api.model.v6_6.installer.v1.MachinePoolPlatformFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>>
extends BaseFluent<A>
implements MachinePoolFluent<A> {
    private String architecture;
    private String hyperthreading;
    private String name;
    private MachinePoolPlatformBuilder platform;
    private Long replicas;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluentImpl() {
    }

    public MachinePoolFluentImpl(MachinePool instance) {
        this.withArchitecture(instance.getArchitecture());
        this.withHyperthreading(instance.getHyperthreading());
        this.withName(instance.getName());
        this.withPlatform(instance.getPlatform());
        this.withReplicas(instance.getReplicas());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public String getArchitecture() {
        return this.architecture;
    }

    @Override
    public A withArchitecture(String architecture) {
        this.architecture = architecture;
        return (A)this;
    }

    @Override
    public Boolean hasArchitecture() {
        return this.architecture != null;
    }

    @Override
    public String getHyperthreading() {
        return this.hyperthreading;
    }

    @Override
    public A withHyperthreading(String hyperthreading) {
        this.hyperthreading = hyperthreading;
        return (A)this;
    }

    @Override
    public Boolean hasHyperthreading() {
        return this.hyperthreading != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public MachinePoolPlatform getPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public MachinePoolPlatform buildPlatform() {
        return this.platform != null ? this.platform.build() : null;
    }

    @Override
    public A withPlatform(MachinePoolPlatform platform) {
        this._visitables.get("platform").remove(this.platform);
        if (platform != null) {
            this.platform = new MachinePoolPlatformBuilder(platform);
            this._visitables.get("platform").add(this.platform);
        } else {
            this.platform = null;
            this._visitables.get("platform").remove(this.platform);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    public MachinePoolFluent.PlatformNested<A> withNewPlatform() {
        return new PlatformNestedImpl();
    }

    @Override
    public MachinePoolFluent.PlatformNested<A> withNewPlatformLike(MachinePoolPlatform item) {
        return new PlatformNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.PlatformNested<A> editPlatform() {
        return this.withNewPlatformLike(this.getPlatform());
    }

    @Override
    public MachinePoolFluent.PlatformNested<A> editOrNewPlatform() {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : new MachinePoolPlatformBuilder().build());
    }

    @Override
    public MachinePoolFluent.PlatformNested<A> editOrNewPlatformLike(MachinePoolPlatform item) {
        return this.withNewPlatformLike(this.getPlatform() != null ? this.getPlatform() : item);
    }

    @Override
    public Long getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Long replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolFluentImpl that = (MachinePoolFluentImpl)o;
        if (this.architecture != null ? !this.architecture.equals(that.architecture) : that.architecture != null) {
            return false;
        }
        if (this.hyperthreading != null ? !this.hyperthreading.equals(that.hyperthreading) : that.hyperthreading != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.architecture, this.hyperthreading, this.name, this.platform, this.replicas, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.architecture != null) {
            sb.append("architecture:");
            sb.append(this.architecture + ",");
        }
        if (this.hyperthreading != null) {
            sb.append("hyperthreading:");
            sb.append(this.hyperthreading + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.platform != null) {
            sb.append("platform:");
            sb.append(this.platform + ",");
        }
        if (this.replicas != null) {
            sb.append("replicas:");
            sb.append(this.replicas + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class PlatformNestedImpl<N>
    extends MachinePoolPlatformFluentImpl<MachinePoolFluent.PlatformNested<N>>
    implements MachinePoolFluent.PlatformNested<N>,
    Nested<N> {
        MachinePoolPlatformBuilder builder;

        PlatformNestedImpl(MachinePoolPlatform item) {
            this.builder = new MachinePoolPlatformBuilder(this, item);
        }

        PlatformNestedImpl() {
            this.builder = new MachinePoolPlatformBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withPlatform(this.builder.build());
        }

        @Override
        public N endPlatform() {
            return this.and();
        }
    }
}

