/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v6_6.hive.vsphere.v1;

import io.fabric8.kubernetes.api.builder.v6_6.BaseFluent;
import io.fabric8.kubernetes.api.builder.v6_6.Nested;
import io.fabric8.openshift.api.model.v6_6.hive.vsphere.v1.MachinePool;
import io.fabric8.openshift.api.model.v6_6.hive.vsphere.v1.MachinePoolFluent;
import io.fabric8.openshift.api.model.v6_6.hive.vsphere.v1.OSDisk;
import io.fabric8.openshift.api.model.v6_6.hive.vsphere.v1.OSDiskBuilder;
import io.fabric8.openshift.api.model.v6_6.hive.vsphere.v1.OSDiskFluentImpl;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class MachinePoolFluentImpl<A extends MachinePoolFluent<A>>
extends BaseFluent<A>
implements MachinePoolFluent<A> {
    private Integer coresPerSocket;
    private Integer cpus;
    private Long memoryMB;
    private OSDiskBuilder osDisk;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluentImpl() {
    }

    public MachinePoolFluentImpl(MachinePool instance) {
        this.withCoresPerSocket(instance.getCoresPerSocket());
        this.withCpus(instance.getCpus());
        this.withMemoryMB(instance.getMemoryMB());
        this.withOsDisk(instance.getOsDisk());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public Integer getCoresPerSocket() {
        return this.coresPerSocket;
    }

    @Override
    public A withCoresPerSocket(Integer coresPerSocket) {
        this.coresPerSocket = coresPerSocket;
        return (A)this;
    }

    @Override
    public Boolean hasCoresPerSocket() {
        return this.coresPerSocket != null;
    }

    @Override
    public Integer getCpus() {
        return this.cpus;
    }

    @Override
    public A withCpus(Integer cpus) {
        this.cpus = cpus;
        return (A)this;
    }

    @Override
    public Boolean hasCpus() {
        return this.cpus != null;
    }

    @Override
    public Long getMemoryMB() {
        return this.memoryMB;
    }

    @Override
    public A withMemoryMB(Long memoryMB) {
        this.memoryMB = memoryMB;
        return (A)this;
    }

    @Override
    public Boolean hasMemoryMB() {
        return this.memoryMB != null;
    }

    @Override
    @Deprecated
    public OSDisk getOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    @Override
    public OSDisk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    @Override
    public A withOsDisk(OSDisk osDisk) {
        this._visitables.get("osDisk").remove(this.osDisk);
        if (osDisk != null) {
            this.osDisk = new OSDiskBuilder(osDisk);
            this._visitables.get("osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get("osDisk").remove(this.osDisk);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOsDisk() {
        return this.osDisk != null;
    }

    @Override
    public A withNewOsDisk(Integer diskSizeGB) {
        return this.withOsDisk(new OSDisk(diskSizeGB));
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNestedImpl();
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> withNewOsDiskLike(OSDisk item) {
        return new OsDiskNestedImpl(item);
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(this.getOsDisk());
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(this.getOsDisk() != null ? this.getOsDisk() : new OSDiskBuilder().build());
    }

    @Override
    public MachinePoolFluent.OsDiskNested<A> editOrNewOsDiskLike(OSDisk item) {
        return this.withNewOsDiskLike(this.getOsDisk() != null ? this.getOsDisk() : item);
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MachinePoolFluentImpl that = (MachinePoolFluentImpl)o;
        if (this.coresPerSocket != null ? !this.coresPerSocket.equals(that.coresPerSocket) : that.coresPerSocket != null) {
            return false;
        }
        if (this.cpus != null ? !this.cpus.equals(that.cpus) : that.cpus != null) {
            return false;
        }
        if (this.memoryMB != null ? !this.memoryMB.equals(that.memoryMB) : that.memoryMB != null) {
            return false;
        }
        if (this.osDisk != null ? !this.osDisk.equals(that.osDisk) : that.osDisk != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.coresPerSocket, this.cpus, this.memoryMB, this.osDisk, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.coresPerSocket != null) {
            sb.append("coresPerSocket:");
            sb.append(this.coresPerSocket + ",");
        }
        if (this.cpus != null) {
            sb.append("cpus:");
            sb.append(this.cpus + ",");
        }
        if (this.memoryMB != null) {
            sb.append("memoryMB:");
            sb.append(this.memoryMB + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(this.osDisk + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    class OsDiskNestedImpl<N>
    extends OSDiskFluentImpl<MachinePoolFluent.OsDiskNested<N>>
    implements MachinePoolFluent.OsDiskNested<N>,
    Nested<N> {
        OSDiskBuilder builder;

        OsDiskNestedImpl(OSDisk item) {
            this.builder = new OSDiskBuilder(this, item);
        }

        OsDiskNestedImpl() {
            this.builder = new OSDiskBuilder(this);
        }

        @Override
        public N and() {
            return (N)MachinePoolFluentImpl.this.withOsDisk(this.builder.build());
        }

        @Override
        public N endOsDisk() {
            return this.and();
        }
    }
}

